/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.Addons;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.impl.CachedProcessEventListenerConfig;
import org.kie.kogito.process.impl.DefaultWorkItemHandlerConfig;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.signal.SignalManagerHub;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.kogito.uow.events.UnitOfWorkEventListener;
import org.kie.services.signal.DefaultSignalManagerHub;

public abstract class AbstractProcessConfig
implements ProcessConfig {
    private final WorkItemHandlerConfig workItemHandlerConfig;
    private final SignalManagerHub signalManagerHub = new DefaultSignalManagerHub();
    private final ProcessEventListenerConfig processEventListenerConfig;
    private final UnitOfWorkManager unitOfWorkManager;
    private final JobsService jobsService;

    protected AbstractProcessConfig(Iterable<WorkItemHandlerConfig> workItemHandlerConfig, Iterable<ProcessEventListenerConfig> processEventListenerConfigs, Iterable<ProcessEventListener> processEventListeners, Iterable<UnitOfWorkManager> unitOfWorkManager, Iterable<JobsService> jobsService, Iterable<EventPublisher> eventPublishers, String kogitoService, Iterable<UnitOfWorkEventListener> unitOfWorkListeners) {
        this.workItemHandlerConfig = AbstractProcessConfig.orDefault(workItemHandlerConfig, DefaultWorkItemHandlerConfig::new);
        this.processEventListenerConfig = AbstractProcessConfig.merge(processEventListenerConfigs, processEventListeners);
        this.unitOfWorkManager = AbstractProcessConfig.orDefault(unitOfWorkManager, () -> new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()));
        this.jobsService = AbstractProcessConfig.orDefault(jobsService, () -> null);
        eventPublishers.forEach(publisher -> this.unitOfWorkManager().eventManager().addPublisher(publisher));
        unitOfWorkListeners.forEach(listener -> this.unitOfWorkManager().register(listener));
        this.unitOfWorkManager().eventManager().setService(kogitoService);
    }

    public WorkItemHandlerConfig workItemHandlers() {
        return this.workItemHandlerConfig;
    }

    public ProcessEventListenerConfig processEventListeners() {
        return this.processEventListenerConfig;
    }

    public SignalManagerHub signalManagerHub() {
        return this.signalManagerHub;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return this.unitOfWorkManager;
    }

    public JobsService jobsService() {
        return this.jobsService;
    }

    public Addons addons() {
        return new Addons(Arrays.asList(new String[0]));
    }

    static <T> T orDefault(Iterable<T> instance, Supplier<? extends T> supplier) {
        Iterator<T> iterator = instance.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return supplier.get();
    }

    static ProcessEventListenerConfig merge(Iterable<ProcessEventListenerConfig> processEventListenerConfigs, Iterable<ProcessEventListener> processEventListeners) {
        List l1 = StreamSupport.stream(processEventListenerConfigs.spliterator(), false).collect(Collectors.toList());
        List l2 = StreamSupport.stream(processEventListeners.spliterator(), false).collect(Collectors.toList());
        Stream processEventListenerStream = l1.stream().flatMap(c -> c.listeners().stream());
        Stream eventListenerStream = l2.stream();
        return new CachedProcessEventListenerConfig(Stream.concat(processEventListenerStream, eventListenerStream).collect(Collectors.toList()));
    }
}

