/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jbpm.process.instance.impl.util.ComparablePeriodSerializer;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;

public class TypeTransformer {
    private ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new SimpleModule().addSerializer(ComparablePeriod.class, (JsonSerializer)new ComparablePeriodSerializer())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
    private ClassLoader classLoader;

    public TypeTransformer() {
        this(TypeTransformer.class.getClassLoader());
    }

    public TypeTransformer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private Object transform(Object toMarshal, Class<?> targetClazz, ClassLoader currentClassLoader, String className) throws ClassNotFoundException, IOException {
        JavaParser parser = new JavaParser();
        ParseResult unit = parser.parseType(className);
        if (!unit.isSuccessful()) {
            return toMarshal;
        }
        ClassOrInterfaceType type = (ClassOrInterfaceType)unit.getResult().get();
        if (Collection.class.isAssignableFrom(targetClazz) && type.getTypeArguments().isPresent()) {
            ClassOrInterfaceType argument = (ClassOrInterfaceType)((NodeList)type.getTypeArguments().get()).get(0);
            Class<?> genericType = currentClassLoader.loadClass(this.toString(argument));
            CollectionType targetGenericType = this.mapper.getTypeFactory().constructCollectionType(List.class, genericType);
            return this.mapper.convertValue(toMarshal, (JavaType)targetGenericType);
        }
        return this.mapper.convertValue(toMarshal, targetClazz);
    }

    public Object transform(Object toMarshal, Class<?> targetClass) throws IOException, ClassNotFoundException {
        return this.transform(toMarshal, targetClass, targetClass.getClassLoader(), targetClass.getName());
    }

    public Object transform(Object toMarshal, String className) throws ClassNotFoundException, IOException {
        return this.transform(toMarshal, this.classLoader.loadClass(className), this.classLoader, className);
    }

    private String toString(ClassOrInterfaceType type) {
        StringBuilder str = new StringBuilder();
        type.getScope().ifPresent(s -> str.append(s.asString()).append("."));
        str.append(type.getNameAsString());
        return str.toString();
    }
}

