/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.validation;

import java.util.stream.Collectors;
import org.kie.kogito.process.validation.ValidationContext;
import org.kie.kogito.process.validation.ValidationDecorator;
import org.kie.kogito.process.validation.ValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationLogDecorator
extends ValidationDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationLogDecorator.class);

    public ValidationLogDecorator(ValidationContext context) {
        super(context);
    }

    public static ValidationLogDecorator of(ValidationContext context) {
        return new ValidationLogDecorator(context);
    }

    @Override
    public ValidationLogDecorator decorate() {
        this.context.resourcesWithError().forEach(id -> {
            String message = this.context.errors((String)id).stream().map(ValidationError::getMessage).collect(Collectors.joining("\n - ", " - ", ""));
            LOGGER.error("Invalid process: '{}'. Found errors:\n{}\n", id, (Object)message);
        });
        return this;
    }
}

