/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.context.variable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.SourceVersion;
import org.drools.util.StringUtils;
import org.jbpm.process.core.TypeObject;
import org.jbpm.process.core.ValueObject;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.UndefinedDataType;

public class Variable
implements TypeObject,
ValueObject,
Serializable {
    private static final long serialVersionUID = 510L;
    public static final String VARIABLE_TAGS = "customTags";
    public static final String READONLY_TAG = "readonly";
    public static final String REQUIRED_TAG = "required";
    public static final String INTERNAL_TAG = "internal";
    public static final String INPUT_TAG = "input";
    public static final String OUTPUT_TAG = "output";
    public static final String BUSINESS_RELEVANT = "business-relevant";
    public static final String TRACKED = "tracked";
    private String id;
    private String name;
    private String sanitizedName;
    private DataType type;
    private Object value;
    private Map<String, Object> metaData = new HashMap<String, Object>();
    private List<String> tags = new ArrayList<String>();

    public Variable() {
        this.type = UndefinedDataType.getInstance();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.sanitizedName = Variable.sanitizeIdentifier(name);
    }

    public String getSanitizedName() {
        return this.sanitizedName;
    }

    private static String sanitizeIdentifier(String name) {
        return Optional.ofNullable(name).filter(SourceVersion::isName).orElseGet(() -> {
            String identifier = StringUtils.extractFirstIdentifier((String)name, (int)0);
            return Optional.ofNullable(identifier).filter(s -> !StringUtils.isEmpty((CharSequence)s)).filter(SourceVersion::isName).orElseGet(() -> String.format("v$%s", identifier));
        });
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public void setType(DataType type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.type = type;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (!this.type.verifyDataType(value)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Value <");
            sb.append(value);
            sb.append("> is not valid for datatype: ");
            sb.append(this.type);
            throw new IllegalArgumentException(sb.toString());
        }
        this.value = value;
    }

    public void setMetaData(String name, Object value) {
        this.metaData.put(name, value);
        if (VARIABLE_TAGS.equals(name) && value != null) {
            this.tags = Arrays.asList(value.toString().split(","));
        }
    }

    public Object getMetaData(String name) {
        return this.metaData.get(name);
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public String toString() {
        return this.name;
    }

    public List<String> getTags() {
        if (this.tags.isEmpty() && this.metaData.containsKey(VARIABLE_TAGS)) {
            this.tags = Arrays.asList(this.metaData.get(VARIABLE_TAGS).toString().split(","));
        }
        return this.tags;
    }

    public Object cloneValue() {
        return this.type.clone(this.getValue());
    }

    public boolean hasTag(String tagName) {
        return this.getTags().contains(tagName);
    }

    public boolean matchByIdOrName(String nameOrId) {
        return this.id.equals(nameOrId) || this.name.equals(nameOrId);
    }
}

