/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.coverter;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloneHelperFactory {
    private static final Logger logger = LoggerFactory.getLogger(CloneHelperFactory.class);

    private CloneHelperFactory() {
    }

    public static UnaryOperator<Object> getCloner(Class<?> type) {
        if (Cloneable.class.isAssignableFrom(type)) {
            try {
                Method m = type.getMethod("clone", new Class[0]);
                return o -> {
                    try {
                        return m.invoke(o, new Object[0]);
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new IllegalStateException(type + " implements cloneable but invocation to clone method failed", ex);
                    }
                };
            }
            catch (NoSuchMethodException ex) {
                logger.warn(type + " implements cloneable but clone method cannot be found", (Throwable)ex);
            }
        }
        return CloneHelperFactory.findCopyConstructor(type).map(c -> o -> {
            try {
                return c.newInstance(o);
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException("Error cloning object " + o + " using copy constructor", ex);
            }
        }).orElse(o -> o);
    }

    private static Optional<Constructor<?>> findCopyConstructor(Class<?> type) {
        try {
            return Optional.of(type.getConstructor(type));
        }
        catch (ReflectiveOperationException ex) {
            for (Constructor<?> constructor : type.getConstructors()) {
                if (constructor.getParameterCount() != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(type)) continue;
                return Optional.of(constructor);
            }
            logger.debug("Cannot find copy constructor for type {}", type);
            return Optional.empty();
        }
    }
}

