/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ReturnValueEvaluator;
import org.jbpm.util.ContextFactory;
import org.jbpm.workflow.core.node.AsyncEventNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstanceContainer;

public class JoinInstance
extends NodeInstanceImpl {
    private static final long serialVersionUID = 510L;
    private Map<Long, Integer> triggers = new HashMap<Long, Integer>();

    protected Join getJoin() {
        return (Join)this.getNode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("An ActionNode only accepts default incoming connections!");
        }
        this.triggerTime = new Date();
        Join join = this.getJoin();
        switch (join.getType()) {
            case 2: {
                this.triggerCompleted();
                return;
            }
            case 1: {
                Integer count = this.triggers.get(from.getNodeId());
                if (count == null) {
                    this.triggers.put(from.getNodeId(), 1);
                } else {
                    this.triggers.put(from.getNodeId(), count + 1);
                }
                if (!this.checkAllActivated()) return;
                this.decreaseAllTriggers();
                this.triggerCompleted();
                return;
            }
            case 3: {
                boolean triggerCompleted = this.triggers.isEmpty();
                this.triggers.put(from.getNodeId(), new Integer(1));
                if (this.checkAllActivated()) {
                    this.resetAllTriggers();
                }
                if (!triggerCompleted) return;
                this.triggerCompleted();
                return;
            }
            case 4: {
                Integer count = this.triggers.get(from.getNodeId());
                if (count == null) {
                    this.triggers.put(from.getNodeId(), 1);
                } else {
                    this.triggers.put(from.getNodeId(), count + 1);
                }
                int counter = 0;
                for (Connection connection : this.getJoin().getDefaultIncomingConnections()) {
                    if (this.triggers.get(connection.getFrom().getId()) == null) continue;
                    ++counter;
                }
                String n = join.getN();
                Integer number = null;
                ReturnValueEvaluator action = (ReturnValueEvaluator)this.getNode().getMetaData().get("Action");
                if (action != null) {
                    try {
                        number = (Integer)action.evaluate(ContextFactory.fromNode(this));
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Error evaluating number of operations", e);
                    }
                } else if (n.startsWith("#{") && n.endsWith("}")) {
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", n = n.substring(2, n.length() - 1));
                    if (variableScopeInstance == null) {
                        throw new IllegalArgumentException("Could not find variable " + n + " when executing join.");
                    }
                    Object value = variableScopeInstance.getVariable(n);
                    if (!(value instanceof Number)) throw new IllegalArgumentException("Variable " + n + " did not return a number when executing join: " + value);
                    number = ((Number)value).intValue();
                } else {
                    number = new Integer(n);
                }
                if (counter < number) return;
                this.resetAllTriggers();
                this.triggerCompleted();
                return;
            }
            case 5: {
                KogitoNodeInstanceContainer nodeInstanceContainer = this.getNodeInstanceContainer();
                boolean activePathExists = this.existsActiveDirectFlow((NodeInstanceContainer)nodeInstanceContainer, (Node)this.getJoin());
                if (activePathExists) return;
                this.triggerCompleted();
                return;
            }
            default: {
                throw new IllegalArgumentException("Illegal join type " + join.getType());
            }
        }
    }

    private boolean checkAllActivated() {
        for (Connection connection : this.getJoin().getDefaultIncomingConnections()) {
            if (this.triggers.get(connection.getFrom().getId()) != null) continue;
            return false;
        }
        return true;
    }

    private void decreaseAllTriggers() {
        for (Connection connection : this.getJoin().getDefaultIncomingConnections()) {
            Integer count = this.triggers.get(connection.getFrom().getId());
            if (count == 1) {
                this.triggers.remove(connection.getFrom().getId());
                continue;
            }
            this.triggers.put(connection.getFrom().getId(), count - 1);
        }
    }

    private boolean existsActiveDirectFlow(NodeInstanceContainer nodeInstanceContainer, final Node lookFor) {
        Collection activeNodeInstancesOrig = nodeInstanceContainer.getNodeInstances();
        ArrayList activeNodeInstances = new ArrayList(activeNodeInstancesOrig);
        Collections.sort(activeNodeInstances, new Comparator<org.kie.api.runtime.process.NodeInstance>(){

            @Override
            public int compare(org.kie.api.runtime.process.NodeInstance o1, org.kie.api.runtime.process.NodeInstance o2) {
                if (o1.getNodeId() == lookFor.getId()) {
                    return 1;
                }
                if (o2.getNodeId() == lookFor.getId()) {
                    return -1;
                }
                return 0;
            }
        });
        for (org.kie.api.runtime.process.NodeInstance nodeInstance : activeNodeInstances) {
            if (((NodeInstance)nodeInstance).getLevel() != this.getLevel()) continue;
            Node node = nodeInstance.getNode();
            HashSet<Long> vistedNodes = new HashSet<Long>();
            this.checkNodes(vistedNodes, node, node, lookFor);
            if (!vistedNodes.contains(lookFor.getId()) || vistedNodes.contains(node.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean checkNodes(Set<Long> vistedNodes, Node startAt, Node currentNode, Node lookFor) {
        if (currentNode == null) {
            return false;
        }
        if (currentNode instanceof AsyncEventNode) {
            currentNode = ((AsyncEventNode)currentNode).getActualNode();
        }
        List connections = currentNode.getOutgoingConnections("DROOLS_DEFAULT");
        if (currentNode instanceof Split && ((Split)currentNode).getType() == 2) {
            if (vistedNodes.contains(startAt.getId())) {
                return false;
            }
            for (Connection conn : connections) {
                HashSet<Long> xorCopy = new HashSet<Long>(vistedNodes);
                Node nextNode = conn.getTo();
                if (nextNode == null) continue;
                xorCopy.add(nextNode.getId());
                if (nextNode.getId() != lookFor.getId()) {
                    this.checkNodes(xorCopy, currentNode, nextNode, lookFor);
                }
                if (!xorCopy.contains(lookFor.getId())) continue;
                vistedNodes.addAll(xorCopy);
                return true;
            }
        } else {
            for (Connection conn : connections) {
                Node nextNode = conn.getTo();
                if (nextNode == null || vistedNodes.contains(nextNode.getId())) continue;
                if (nextNode.getId() == lookFor.getId()) {
                    vistedNodes.add(nextNode.getId());
                    continue;
                }
                vistedNodes.add(nextNode.getId());
                if (startAt.getId() == nextNode.getId()) {
                    return true;
                }
                boolean nestedCheck = this.checkNodes(vistedNodes, startAt, nextNode, lookFor);
                if (!nestedCheck) continue;
                return true;
            }
        }
        return false;
    }

    private void resetAllTriggers() {
        this.triggers.clear();
    }

    public void triggerCompleted() {
        this.triggerCompleted("DROOLS_DEFAULT", this.triggers.isEmpty());
    }

    public Map<Long, Integer> getTriggers() {
        return this.triggers;
    }

    public void internalSetTriggers(Map<Long, Integer> triggers) {
        this.triggers = triggers;
    }
}

