/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalAgenda;
import org.drools.core.spi.KogitoProcessContextImpl;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.EndNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.kogito.event.process.ContextAwareEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;

public class DynamicNodeInstance
extends CompositeContextNodeInstance {
    private static final long serialVersionUID = 510L;

    private String getRuleFlowGroupName() {
        return this.getNodeName();
    }

    protected DynamicNode getDynamicNode() {
        return (DynamicNode)this.getNode();
    }

    @Override
    public String getNodeName() {
        return this.resolveVariable(super.getNodeName());
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        this.triggerTime = new Date();
        this.triggerEvent("onEntry");
        if (this.getNodeInstanceContainer().getNodeInstance(this.getStringId()) == null) {
            return;
        }
        if (this.canActivate()) {
            this.triggerActivated();
        } else {
            this.setState(0);
            this.addActivationListener();
        }
    }

    private void triggerActivated() {
        this.setState(1);
        List<Node> autoStartNodes = this.getDynamicNode().getAutoStartNodes();
        autoStartNodes.forEach(autoStartNode -> this.triggerSelectedNode((Node)autoStartNode, null));
    }

    private boolean canActivate() {
        KogitoProcessContextImpl context = new KogitoProcessContextImpl((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
        context.setNodeInstance((org.kie.api.runtime.process.NodeInstance)this);
        return this.getDynamicNode().canActivate((ProcessContext)context);
    }

    private boolean canComplete() {
        KogitoProcessContextImpl context = new KogitoProcessContextImpl((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
        context.setNodeInstance((org.kie.api.runtime.process.NodeInstance)this);
        return this.getNodeInstances(false).isEmpty() && this.getDynamicNode().canComplete((ProcessContext)context);
    }

    private void addActivationListener() {
        this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime().addEventListener(ContextAwareEventListener.using(listener -> {
            if (this.canActivate() && this.getState() == 0) {
                this.triggerActivated();
                this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime().removeEventListener((ProcessEventListener)listener);
            }
        }));
    }

    private void addCompletionListener() {
        this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime().addEventListener(ContextAwareEventListener.using(listener -> {
            if (this.canComplete()) {
                this.triggerCompleted("DROOLS_DEFAULT");
            }
        }));
    }

    @Override
    public void nodeInstanceCompleted(NodeInstance nodeInstance, String outType) {
        Object compensationBoolObj;
        Node nodeInstanceNode = nodeInstance.getNode();
        if (nodeInstanceNode != null && Boolean.TRUE.equals(compensationBoolObj = nodeInstanceNode.getMetaData().get("isForCompensation"))) {
            return;
        }
        if (this.isTerminated((org.kie.api.runtime.process.NodeInstance)nodeInstance) || this.canComplete()) {
            this.triggerCompleted("DROOLS_DEFAULT");
        }
        if (!this.canComplete()) {
            this.addCompletionListener();
        }
    }

    @Override
    public void triggerCompleted(String outType) {
        if (this.getProcessInstance().getKnowledgeRuntime().getAgenda() != null) {
            ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).deactivateRuleFlowGroup(this.getRuleFlowGroupName());
        }
        super.triggerCompleted(outType);
    }

    protected boolean isTerminated(org.kie.api.runtime.process.NodeInstance from) {
        if (from instanceof EndNodeInstance) {
            return ((EndNodeInstance)from).getEndNode().isTerminate();
        }
        return false;
    }

    protected void triggerSelectedNode(Node node, Object event) {
        NodeInstance nodeInstance = this.getNodeInstance(node);
        if (event != null) {
            HashMap<String, Object> dynamicParams = new HashMap<String, Object>();
            if (event instanceof Map) {
                dynamicParams.putAll((Map)event);
            } else {
                dynamicParams.put("Data", event);
            }
            nodeInstance.setDynamicParameters(dynamicParams);
        }
        nodeInstance.trigger(null, "DROOLS_DEFAULT");
    }
}

