/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.context.exception;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jbpm.process.core.context.exception.AbstractHierarchyExceptionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageContentRegexExceptionPolicy
extends AbstractHierarchyExceptionPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageContentRegexExceptionPolicy.class);

    @Override
    protected boolean verify(String errorCode, Throwable exception) {
        String msg = exception.getMessage();
        if (msg != null) {
            try {
                return Pattern.compile(errorCode).matcher(msg).find();
            }
            catch (PatternSyntaxException ex) {
                LOGGER.debug("Failure parsing regular expression: {}", (Object)errorCode, (Object)ex);
            }
        }
        return false;
    }
}

