/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.coverter;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import org.jbpm.process.core.datatype.impl.coverter.CloneHelperRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloneHelper {
    private static final Logger logger = LoggerFactory.getLogger(CloneHelper.class);
    private static final CloneHelper instance = new CloneHelper(CloneHelperRegister.get().getCloners());
    private Map<Class<?>, UnaryOperator<?>> cloners;
    private final Map<Class<?>, UnaryOperator<?>> registeredCloners;

    public static synchronized CloneHelper get() {
        return instance;
    }

    private CloneHelper(Map<Class<?>, UnaryOperator<?>> registeredCloners) {
        this.registeredCloners = registeredCloners;
        this.cloners = new ConcurrentHashMap(registeredCloners);
    }

    public <T> T clone(T value) {
        return (T)(value == null ? value : this.getCloner(value.getClass()).apply(value));
    }

    public <T> UnaryOperator<T> getCloner(Class<T> type) {
        return this.cloners.computeIfAbsent(type, this::searchCloner);
    }

    private UnaryOperator<?> searchCloner(Class<?> type) {
        return this.searchRegistered(type).or(() -> this.searchCopyConstructor(type)).or(() -> this.searchCloneable(type)).orElse(o -> o);
    }

    private Optional<UnaryOperator<?>> searchRegistered(Class<?> type) {
        return this.registeredCloners.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(type)).map(Map.Entry::getValue).findFirst();
    }

    private Optional<UnaryOperator<?>> searchCloneable(Class<?> type) {
        if (Cloneable.class.isAssignableFrom(type)) {
            try {
                Method m = type.getMethod("clone", new Class[0]);
                return Optional.of(o -> {
                    try {
                        return m.invoke(o, new Object[0]);
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new IllegalStateException(type + " implements cloneable but invocation to clone method failed", ex);
                    }
                });
            }
            catch (NoSuchMethodException ex) {
                logger.warn("{} implements cloneable but clone method cannot be found", type);
            }
        }
        return Optional.empty();
    }

    private Optional<UnaryOperator<?>> searchCopyConstructor(Class<?> type) {
        return this.findCopyConstructor(type).map(c -> o -> {
            try {
                return c.newInstance(o);
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException("Error cloning object " + o + " using copy constructor", ex);
            }
        });
    }

    private Optional<Constructor<?>> findCopyConstructor(Class<?> type) {
        try {
            return Optional.of(type.getConstructor(type));
        }
        catch (ReflectiveOperationException ex) {
            for (Constructor<?> constructor : type.getConstructors()) {
                if (constructor.getParameterCount() != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(type)) continue;
                return Optional.of(constructor);
            }
            logger.debug("Cannot find copy constructor for type {}", type);
            return Optional.empty();
        }
    }
}

