/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.process.core.transformation.MVELDataTransformer;
import org.kie.api.runtime.process.DataTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransformerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DataTransformerRegistry.class);
    private static final DataTransformerRegistry INSTANCE = new DataTransformerRegistry();
    private Map<String, DataTransformer> registry = new ConcurrentHashMap<String, DataTransformer>();

    protected DataTransformerRegistry() {
        this.registry.put("http://www.mvel.org/2.0", new MVELDataTransformer());
    }

    public static DataTransformerRegistry get() {
        return INSTANCE;
    }

    public synchronized void register(String language, DataTransformer transformer) {
        this.registry.put(language, transformer);
        logger.debug("Manual registration of scripting language {} with instance {}", (Object)language, (Object)transformer);
    }

    public DataTransformer find(String language) {
        return this.registry.get(language);
    }
}

