/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.context.variable;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.impl.coverter.CloneHelper;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.AbstractContextInstance;
import org.jbpm.process.instance.context.variable.VariableScopeListener;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.kie.api.runtime.KieRuntime;
import org.kie.kogito.internal.process.event.KogitoObjectListener;
import org.kie.kogito.internal.process.event.KogitoObjectListenerAware;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.process.VariableViolationException;

public class VariableScopeInstance
extends AbstractContextInstance {
    private static final long serialVersionUID = 510L;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private transient String variableIdPrefix = null;
    private transient String variableInstanceIdPrefix = null;

    @Override
    public String getContextType() {
        return "VariableScope";
    }

    public Object getVariable(String name) {
        Object value = this.variables.get(name);
        if (value != null) {
            return value;
        }
        if ("processInstanceId".equals(name) && this.getProcessInstance() != null) {
            return this.getProcessInstance().getStringId();
        }
        if ("parentProcessInstanceId".equals(name) && this.getProcessInstance() != null) {
            return this.getProcessInstance().getParentProcessInstanceId();
        }
        if (this.getProcessInstance() != null && this.getProcessInstance().getKnowledgeRuntime() != null && (value = this.getProcessInstance().getKnowledgeRuntime().getGlobal(name)) != null) {
            return value;
        }
        return null;
    }

    public Map<String, Object> getVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    public void setVariable(String name, Object value) {
        this.setVariable(null, name, value);
    }

    public void setVariable(KogitoNodeInstance nodeInstance, String name, Object value) {
        Objects.requireNonNull(name, "The name of a variable may not be null!");
        VariableScope scope = this.getVariableScope();
        ProcessInstance pi = this.getProcessInstance();
        Object oldValue = this.getVariable(name);
        if (oldValue != null && scope.isReadOnly(name)) {
            throw new VariableViolationException(pi.getStringId(), name, "Variable '" + name + "' is already set and is marked as read only");
        }
        if (this.ignoreChange(oldValue, value)) {
            return;
        }
        List<String> tags = scope.tags(name);
        Object newValue = value;
        InternalKnowledgeRuntime runtime = pi.getKnowledgeRuntime();
        if (runtime != null) {
            if (!tags.contains("internal")) {
                newValue = CloneHelper.get().clone(value);
            }
            this.getProcessEventSupport().fireBeforeVariableChanged((String)(this.variableIdPrefix == null ? "" : this.variableIdPrefix + ":") + name, (String)(this.variableInstanceIdPrefix == null ? "" : this.variableInstanceIdPrefix + ":") + name, oldValue, newValue, tags, (KogitoProcessInstance)pi, nodeInstance, (KieRuntime)runtime);
        }
        this.internalSetVariable(name, value);
        if (runtime != null) {
            this.getProcessEventSupport().fireAfterVariableChanged((String)(this.variableIdPrefix == null ? "" : this.variableIdPrefix + ":") + name, (String)(this.variableInstanceIdPrefix == null ? "" : this.variableInstanceIdPrefix + ":") + name, oldValue, newValue, tags, (KogitoProcessInstance)pi, nodeInstance, (KieRuntime)runtime);
        }
    }

    private boolean ignoreChange(Object oldValue, Object newValue) {
        if (newValue instanceof KogitoObjectListenerAware) {
            return Objects.equals(oldValue, newValue) || oldValue == null && ((KogitoObjectListenerAware)newValue).isEmpty();
        }
        return oldValue == null && newValue == null;
    }

    private KogitoProcessEventSupport getProcessEventSupport() {
        return ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getProcessEventSupport();
    }

    public void internalSetVariable(String name, Object value) {
        if (value instanceof KogitoObjectListenerAware) {
            ((KogitoObjectListenerAware)value).addKogitoObjectListener((KogitoObjectListener)new VariableScopeListener(this.getProcessInstance(), name, this.variableIdPrefix, this.variableInstanceIdPrefix, this.getVariableScope().tags(name)));
        }
        this.variables.put(name, value);
    }

    public VariableScope getVariableScope() {
        return (VariableScope)this.getContext();
    }

    @Override
    public void setContextInstanceContainer(ContextInstanceContainer contextInstanceContainer) {
        super.setContextInstanceContainer(contextInstanceContainer);
        for (Variable variable : this.getVariableScope().getVariables()) {
            if (variable.getValue() == null) continue;
            this.internalSetVariable(variable.getName(), variable.cloneValue());
        }
        if (contextInstanceContainer instanceof CompositeContextNodeInstance) {
            this.variableIdPrefix = ((Node)((CompositeContextNodeInstance)contextInstanceContainer).getNode()).getUniqueId();
            this.variableInstanceIdPrefix = ((CompositeContextNodeInstance)contextInstanceContainer).getUniqueId();
        }
    }

    public void enforceRequiredVariables() {
        VariableScope variableScope = this.getVariableScope();
        for (Variable variable : variableScope.getVariables()) {
            if (!variableScope.isRequired(variable.getName()) || this.variables.containsKey(variable.getName())) continue;
            throw new VariableViolationException(this.getProcessInstance().getStringId(), variable.getName(), "Variable '" + variable.getName() + "' is required but not set");
        }
    }
}

