/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.Collection;
import java.util.Map;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.kie.api.KieBase;
import org.kie.api.event.process.ProcessEventManager;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.kogito.Application;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.jobs.JobsService;

public class KogitoProcessRuntimeImpl
implements KogitoProcessRuntime {
    private final InternalProcessRuntime delegate;

    public KogitoProcessRuntimeImpl(InternalProcessRuntime delegate) {
        this.delegate = delegate;
    }

    public KogitoProcessInstance startProcess(String processId) {
        return (KogitoProcessInstance)this.delegate.startProcess(processId);
    }

    public KogitoProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return (KogitoProcessInstance)this.delegate.startProcess(processId, parameters);
    }

    public KogitoProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return (KogitoProcessInstance)this.delegate.createProcessInstance(processId, parameters);
    }

    public KogitoProcessInstance startProcess(String processId, AgendaFilter agendaFilter) {
        return (KogitoProcessInstance)this.delegate.startProcess(processId, agendaFilter);
    }

    public KogitoProcessInstance startProcess(String processId, Map<String, Object> parameters, AgendaFilter agendaFilter) {
        return (KogitoProcessInstance)this.delegate.startProcess(processId, parameters, agendaFilter);
    }

    public KogitoProcessInstance startProcessInstance(String processInstanceId) {
        return this.startProcessInstance(processInstanceId, null);
    }

    public KogitoProcessInstance startProcessInstance(String processInstanceId, String trigger) {
        return this.startProcessInstance(processInstanceId, trigger, null);
    }

    public void signalEvent(String type, Object event) {
        this.delegate.signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, String processInstanceId) {
        this.delegate.getSignalManager().signalEvent(processInstanceId, type, event);
    }

    public Collection<KogitoProcessInstance> getKogitoProcessInstances() {
        return this.delegate.getProcessInstances();
    }

    public KogitoProcessInstance getProcessInstance(String id) {
        return this.getProcessInstance(id, false);
    }

    public KogitoProcessInstance getProcessInstance(String id, boolean readOnly) {
        return this.delegate.getProcessInstanceManager().getProcessInstance(id, readOnly);
    }

    public void abortProcessInstance(String processInstanceId) {
        KogitoProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + processInstanceId);
        }
        ((ProcessInstance)processInstance).setState(3);
    }

    public KogitoWorkItemManager getKogitoWorkItemManager() {
        return (KogitoWorkItemManager)this.delegate.getWorkItemManager();
    }

    public KogitoProcessEventSupport getProcessEventSupport() {
        return this.delegate.getProcessEventSupport();
    }

    public ProcessEventManager getProcessEventManager() {
        return this.delegate;
    }

    public JobsService getJobsService() {
        return this.delegate.getJobsService();
    }

    public KieRuntime getKieRuntime() {
        return this.delegate.getInternalKieRuntime();
    }

    public KieBase getKieBase() {
        return this.delegate.getInternalKieRuntime().getKieBase();
    }

    public KieSession getKieSession() {
        if (this.delegate.getInternalKieRuntime() instanceof KieSession) {
            return (KieSession)this.delegate.getInternalKieRuntime();
        }
        return null;
    }

    public KogitoProcessInstance startProcess(String processId, Map<String, Object> parameters, String trigger, AgendaFilter agendaFilter) {
        KogitoProcessInstance processInstance = this.createProcessInstance(processId, parameters);
        if (processInstance != null) {
            return this.startProcessInstance(processInstance.getStringId(), trigger, agendaFilter);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KogitoProcessInstance startProcessInstance(String processInstanceId, String trigger, AgendaFilter agendaFilter) {
        try {
            this.delegate.getInternalKieRuntime().startOperation();
            KogitoProcessInstance processInstance = this.getProcessInstance(processInstanceId);
            ProcessInstance jbpmProcessInstance = (ProcessInstance)processInstance;
            jbpmProcessInstance.configureTimers();
            this.delegate.getProcessEventSupport().fireBeforeProcessStarted(processInstance, (KieRuntime)this.delegate.getInternalKieRuntime());
            jbpmProcessInstance.setAgendaFilter(agendaFilter);
            jbpmProcessInstance.start(trigger);
            this.delegate.getProcessEventSupport().fireAfterProcessStarted(processInstance, (KieRuntime)this.delegate.getInternalKieRuntime());
            ProcessInstance processInstance2 = jbpmProcessInstance;
            return processInstance2;
        }
        finally {
            this.delegate.getInternalKieRuntime().endOperation();
        }
    }

    public Application getApplication() {
        return this.delegate.getApplication();
    }
}

