/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype;

import java.util.HashSet;
import java.util.Set;
import org.jbpm.process.core.datatype.DataType;

public class DataTypeUtils {
    private static final Set<String> langClasses = new HashSet<String>();

    public static String ensureLangPrefix(String type) {
        return langClasses.contains(type) ? "java.lang." + type : type;
    }

    public static boolean isAssignableFrom(DataType target, DataType src) {
        if (target == src || target.equals(src)) {
            return true;
        }
        try {
            return target.getObjectClass().isAssignableFrom(src.getObjectClass());
        }
        catch (Exception exception) {
            return target.getStringType().equals(src.getStringType());
        }
    }

    private DataTypeUtils() {
    }

    static {
        langClasses.add("Integer");
        langClasses.add("Boolean");
        langClasses.add("String");
        langClasses.add("Float");
        langClasses.add("Object");
    }
}

