/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class Timer
implements Serializable {
    public static final int TIME_DURATION = 1;
    public static final int TIME_CYCLE = 2;
    public static final int TIME_DATE = 3;
    private final String id;
    private String delay;
    private String period;
    private String date;
    private int timeType;

    public Timer() {
        this(UUID.randomUUID().toString());
    }

    public Timer(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getDelay() {
        return this.delay;
    }

    public void setDelay(String delay) {
        this.delay = delay;
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String toString() {
        Object result = "Timer";
        if (this.delay != null || this.period != null) {
            result = (String)result + "[";
            if (this.delay != null) {
                result = (String)result + "delay=" + this.delay;
                if (this.period != null) {
                    result = (String)result + ", ";
                }
            }
            if (this.period != null) {
                result = (String)result + "period=" + this.period;
            }
            if (this.date != null) {
                result = (String)result + "date=" + this.date;
            }
            result = (String)result + "]";
        }
        return result;
    }

    public int getTimeType() {
        if (this.timeType == 0) {
            this.timeType = this.date != null && this.date.trim().length() > 0 ? 3 : (this.delay != null && this.delay.trim().length() > 0 && this.period != null && this.period.trim().length() > 0 ? 2 : 1);
        }
        return this.timeType;
    }

    public void setTimeType(int timeType) {
        this.timeType = timeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Timer)) {
            return false;
        }
        Timer timer = (Timer)o;
        return this.timeType == timer.timeType && Objects.equals(this.id, timer.id) && Objects.equals(this.delay, timer.delay) && Objects.equals(this.period, timer.period) && Objects.equals(this.date, timer.date);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.delay, this.period, this.date, this.timeType);
    }
}

