/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.workflow.core.node.AsyncEventNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.kogito.internal.process.event.KogitoEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.services.uow.BaseWorkUnit;
import org.kie.kogito.timer.TimerInstance;
import org.kie.kogito.uow.WorkUnit;

public class AsyncEventNodeInstance
extends EventNodeInstance {
    private static final long serialVersionUID = 1L;
    private final KogitoEventListener listener = new AsyncExternalEventListener();
    private String jobId = "";

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        this.addEventListeners();
        this.addAsyncStatus();
        InternalProcessRuntime processRuntime = (InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime();
        this.setJobId(this.getStringId());
        processRuntime.getUnitOfWorkManager().currentUnitOfWork().intercept((WorkUnit)new BaseWorkUnit((Object)this, instance -> {
            ExactExpirationTime expirationTime = ExactExpirationTime.of((ZonedDateTime)ZonedDateTime.now().plus(1L, ChronoUnit.MILLIS));
            ProcessInstanceJobDescription jobDescription = ProcessInstanceJobDescription.builder().timerId(this.getJobId()).expirationTime((ExpirationTime)expirationTime).processInstanceId(instance.getProcessInstance().getStringId()).rootProcessInstanceId(instance.getProcessInstance().getRootProcessInstanceId()).processId(instance.getProcessInstance().getProcessId()).rootProcessId(instance.getProcessInstance().getRootProcessId()).nodeInstanceId((String)Optional.ofNullable(from).map(KogitoNodeInstance::getStringId).orElse(null)).build();
            JobsService jobService = processRuntime.getJobsService();
            String jobId = jobService.scheduleProcessInstanceJob(jobDescription);
            this.setJobId(jobId);
        }, i -> {}, Integer.valueOf(1000)));
    }

    private void addAsyncStatus() {
        this.getProcessInstance().getMetaData().put("ASYNC_WAITING", true);
    }

    private void clearAsyncStatus() {
        this.getProcessInstance().getMetaData().remove("ASYNC_WAITING");
    }

    @Override
    public void addEventListeners() {
        this.getProcessInstance().addEventListener(this.getEventType(), this.getEventListener(), true);
    }

    @Override
    public String getEventType() {
        return "timerTriggered";
    }

    @Override
    public Node getNode() {
        return new AsyncEventNode(super.getNode());
    }

    public Node getActualNode() {
        return super.getNode();
    }

    @Override
    protected KogitoEventListener getEventListener() {
        return this.listener;
    }

    @Override
    public void cancel() {
        ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getJobsService().cancelJob(this.getJobId());
        super.cancel();
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public void triggerCompleted() {
        this.getProcessInstance().removeEventListener(this.getEventType(), this.getEventListener(), true);
        NodeInstanceContainer instanceContainer = (NodeInstanceContainer)this.getNodeInstanceContainer();
        instanceContainer.setCurrentLevel(this.getLevel());
        instanceContainer.removeNodeInstance(this);
        instanceContainer.setState(1);
        NodeInstance actualInstance = instanceContainer.getNodeInstance(this.getNode());
        this.triggerNodeInstance(actualInstance, "DROOLS_DEFAULT");
        this.clearAsyncStatus();
    }

    private class AsyncExternalEventListener
    implements KogitoEventListener {
        private AsyncExternalEventListener() {
        }

        public String[] getEventTypes() {
            return new String[]{AsyncEventNodeInstance.this.getEventType()};
        }

        public void signalEvent(String type, Object event) {
            if (event instanceof TimerInstance) {
                TimerInstance timerInstance = (TimerInstance)event;
                if (Objects.equals(AsyncEventNodeInstance.this.getJobId(), timerInstance.getId())) {
                    AsyncEventNodeInstance.this.triggerCompleted();
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AsyncExternalEventListener)) {
                return false;
            }
            AsyncExternalEventListener that = (AsyncExternalEventListener)o;
            return Objects.equals(this.getEventTypes(), that.getEventTypes());
        }

        public int hashCode() {
            return Objects.hash(this.getEventTypes());
        }
    }
}

