/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;

public class DefaultProcessInstanceManager
implements ProcessInstanceManager {
    private Map<String, KogitoProcessInstance> processInstances = new ConcurrentHashMap<String, KogitoProcessInstance>();

    @Override
    public void addProcessInstance(KogitoProcessInstance processInstance) {
        String id = UUID.randomUUID().toString();
        ((ProcessInstance)processInstance).setId(id);
        this.internalAddProcessInstance(processInstance);
    }

    @Override
    public void internalAddProcessInstance(KogitoProcessInstance processInstance) {
        this.processInstances.put(processInstance.getStringId(), processInstance);
    }

    @Override
    public Collection<KogitoProcessInstance> getProcessInstances() {
        return Collections.unmodifiableCollection(this.processInstances.values());
    }

    @Override
    public KogitoProcessInstance getProcessInstance(String id) {
        return this.processInstances.get(id);
    }

    @Override
    public KogitoProcessInstance getProcessInstance(String id, boolean readOnly) {
        return this.processInstances.get(id);
    }

    @Override
    public void removeProcessInstance(KogitoProcessInstance processInstance) {
        this.internalRemoveProcessInstance(processInstance);
    }

    @Override
    public void internalRemoveProcessInstance(KogitoProcessInstance processInstance) {
        this.processInstances.remove(processInstance.getStringId());
    }

    @Override
    public void clearProcessInstances() {
        this.processInstances.clear();
    }

    @Override
    public void clearProcessInstancesState() {
    }
}

