/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.actions;

import java.io.Serializable;
import java.util.Collection;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;

public class CancelNodeInstanceAction
implements Action,
Serializable {
    private static final long serialVersionUID = 1L;
    private String attachedToNodeId;

    public CancelNodeInstanceAction(String attachedToNodeId) {
        this.attachedToNodeId = attachedToNodeId;
    }

    @Override
    public void execute(KogitoProcessContext context) throws Exception {
        WorkflowProcessInstance pi = context.getNodeInstance().getProcessInstance();
        NodeInstance nodeInstance = this.findNodeByUniqueId(pi.getNodeInstances(), this.attachedToNodeId);
        if (nodeInstance != null) {
            ((org.jbpm.workflow.instance.NodeInstance)nodeInstance).cancel();
        }
    }

    private NodeInstance findNodeByUniqueId(Collection<NodeInstance> nodeInstances, String uniqueId) {
        if (nodeInstances != null && !nodeInstances.isEmpty()) {
            for (NodeInstance nInstance : nodeInstances) {
                NodeInstance nodeInstance;
                String nodeUniqueId = (String)nInstance.getNode().getMetaData().get("UniqueId");
                if (uniqueId.equals(nodeUniqueId)) {
                    return nInstance;
                }
                if (!(nInstance instanceof CompositeNodeInstance) || (nodeInstance = this.findNodeByUniqueId(((CompositeNodeInstance)nInstance).getNodeInstances(), uniqueId)) == null) continue;
                return nodeInstance;
            }
        }
        return null;
    }
}

