/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.rule;

import java.util.Optional;
import java.util.ServiceLoader;
import org.jbpm.workflow.instance.node.RuleSetNodeInstance;
import org.jbpm.workflow.instance.rule.AbstractRuleType;
import org.jbpm.workflow.instance.rule.DecisionRuleTypeEngine;

public class DecisionRuleType
extends AbstractRuleType {
    static Optional<DecisionRuleTypeEngine> ruleTypeEngineProvider;
    private String namespace;
    private String decision;

    protected DecisionRuleType(String namespace, String model, String decision) {
        super(model);
        this.namespace = namespace;
        this.decision = decision;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getModel() {
        return this.getName();
    }

    public String getDecision() {
        return this.decision;
    }

    @Override
    public boolean isDecision() {
        return true;
    }

    public String toString() {
        return "DecisionRuleType{namespace='" + this.namespace + "', decision='" + this.decision + "', name='" + this.name + "'}";
    }

    @Override
    public void evaluate(RuleSetNodeInstance rsni) {
        ruleTypeEngineProvider.orElseThrow(() -> new IllegalArgumentException("Engine not found for executing DMN rules")).evaluate(rsni, this.getNamespace(), this.getModel(), this.getDecision());
    }

    static {
        ServiceLoader<DecisionRuleTypeEngine> providers = ServiceLoader.load(DecisionRuleTypeEngine.class);
        ruleTypeEngineProvider = providers.findFirst();
    }
}

