/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.context.exception;

import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.kie.api.definition.process.Process;

public class CompensationScope
extends ExceptionScope {
    private static final long serialVersionUID = 510L;
    public static final String COMPENSATION_SCOPE = "CompensationScope";
    public static final String IMPLICIT_COMPENSATION_PREFIX = "implicit:";
    private String containerId;

    @Override
    public String getType() {
        return COMPENSATION_SCOPE;
    }

    @Override
    public void setContextContainer(ContextContainer contextContainer) {
        assert (contextContainer instanceof NodeContainer) : "CompensationScope context container instance is NOT an instance of a node container! (" + contextContainer.getClass().getSimpleName() + ")";
        super.setContextContainer(contextContainer);
        if (contextContainer instanceof NodeImpl) {
            this.containerId = (String)((NodeImpl)((Object)contextContainer)).getMetaData("UniqueId");
        } else if (contextContainer instanceof RuleFlowProcess) {
            this.containerId = ((Process)contextContainer).getId();
        }
    }

    public void setContextContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getContextContainerId() {
        return this.containerId;
    }

    @Override
    public ExceptionHandler getExceptionHandler(String exception) {
        return (ExceptionHandler)this.exceptionHandlers.get(exception);
    }

    @Override
    public Context resolveContext(Object activityRefStr) {
        String containerRef;
        if (activityRefStr == null || !(activityRefStr instanceof String)) {
            throw new IllegalArgumentException("CompensationScope can only resolve based on node id strings: " + activityRefStr);
        }
        String activityRef = (String)activityRefStr;
        if (this.getExceptionHandler(activityRef) != null) {
            return this;
        }
        if (activityRef.startsWith(IMPLICIT_COMPENSATION_PREFIX) && this.containerId.equals(containerRef = activityRef.substring(IMPLICIT_COMPENSATION_PREFIX.length()))) {
            return this;
        }
        return null;
    }
}

