/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.humantask;

import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jbpm.process.instance.impl.humantask.DeadlineInfo;
import org.jbpm.process.instance.impl.humantask.Reassignment;
import org.jbpm.process.instance.impl.humantask.ScheduleInfo;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadlineHelper {
    private static final Logger logger = LoggerFactory.getLogger(DeadlineHelper.class);
    private static final Pattern deadLineSeparatorPattern = Pattern.compile("\\^");
    private static final Pattern listSeparatorPattern = Pattern.compile(",");

    private DeadlineHelper() {
    }

    public static ExpirationTime getExpirationTime(ScheduleInfo info) {
        DurationExpirationTime expirationTime;
        int numRepetitions = info.getNumRepetitions();
        if (numRepetitions == 0) {
            expirationTime = info.getEndDate() == null ? DurationExpirationTime.after((long)DeadlineHelper.getDuration(info)) : ExactExpirationTime.of((ZonedDateTime)info.getEndDate());
        } else if (info.getStartDate() != null) {
            long duration = info.getEndDate() == null ? DeadlineHelper.getDuration(info) : ChronoUnit.MILLIS.between(info.getStartDate(), info.getEndDate());
            expirationTime = DurationExpirationTime.repeat((long)Instant.now().until(info.getStartDate(), ChronoUnit.MILLIS), (Long)duration, (Integer)numRepetitions);
        } else if (info.getEndDate() != null) {
            if (numRepetitions <= 0) {
                numRepetitions = (int)(Instant.now().until(info.getEndDate(), ChronoUnit.MILLIS) / DeadlineHelper.getDuration(info));
            }
            expirationTime = numRepetitions <= 1 ? ExactExpirationTime.of((ZonedDateTime)info.getEndDate()) : DurationExpirationTime.repeat((long)Instant.now().until(info.getEndDate().minus(info.getDuration().multipliedBy(numRepetitions)), ChronoUnit.MILLIS), (Long)DeadlineHelper.getDuration(info), (Integer)numRepetitions);
        } else {
            long duration = DeadlineHelper.getDuration(info);
            expirationTime = DurationExpirationTime.repeat((long)duration, (Long)duration, (Integer)numRepetitions);
        }
        return expirationTime;
    }

    public static Collection<DeadlineInfo<Reassignment>> parseReassignments(Object text) {
        return DeadlineHelper.parseDeadlines(text, DeadlineHelper::parseReassigment, DeadlineHelper::getReassignmentSchedule);
    }

    public static Collection<DeadlineInfo<Map<String, Object>>> parseDeadlines(Object text) {
        return DeadlineHelper.parseDeadlines(text, DeadlineHelper::asMap, DeadlineHelper::getSchedulesInfo);
    }

    private static <T> Collection<DeadlineInfo<T>> parseDeadlines(Object text, Function<String, T> notificationFunction, Function<String, Collection<ScheduleInfo>> scheduleFunction) {
        logger.debug("Parsing deadlines for text {}", text);
        return text == null ? Collections.emptySet() : (Collection)deadLineSeparatorPattern.splitAsStream(text.toString().trim()).map(t -> DeadlineHelper.parseDeadline(t, notificationFunction, scheduleFunction)).collect(Collectors.toSet());
    }

    private static <T> DeadlineInfo<T> parseDeadline(String text, Function<String, T> notificationFunction, Function<String, Collection<ScheduleInfo>> scheduleFunction) {
        if ((text = text.trim()).startsWith("[") && text.endsWith("]")) {
            DeadlineInfo<T> deadline = new DeadlineInfo<T>();
            int indexOf = text.indexOf("]@[");
            deadline.setNotification(notificationFunction.apply(text.substring(1, indexOf).trim()));
            deadline.setScheduleInfo(scheduleFunction.apply(text.substring(indexOf + 3, text.length() - 1).trim()));
            return deadline;
        }
        throw new IllegalArgumentException("Invalid formar for dead line expression " + text);
    }

    private static Collection<ScheduleInfo> getReassignmentSchedule(String timeStr) {
        ScheduleInfo info = new ScheduleInfo();
        if (!((String)timeStr).startsWith("PT")) {
            timeStr = "PT" + (String)timeStr;
        }
        info.setDuration(Duration.parse((CharSequence)timeStr));
        return Collections.singletonList(info);
    }

    private static Collection<ScheduleInfo> getSchedulesInfo(String timeStr) {
        ArrayList<ScheduleInfo> schedules = new ArrayList<ScheduleInfo>();
        for (String item : timeStr.split(",")) {
            schedules.add(DeadlineHelper.getScheduleInfo(item));
        }
        return schedules;
    }

    private static ScheduleInfo getScheduleInfo(String timeStr) {
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        String[] dateComponents = timeStr.split("/");
        if (dateComponents[0].startsWith("R")) {
            int numRepetitions = DeadlineHelper.numRepetitions(dateComponents[0]);
            scheduleInfo.setNumRepetitions(numRepetitions);
            if (DeadlineHelper.isDuration(dateComponents[1])) {
                scheduleInfo.setDuration(DeadlineHelper.parseDuration(dateComponents[1]));
                if (dateComponents.length == 3) {
                    scheduleInfo.setEndDate(ZonedDateTime.parse(dateComponents[2]));
                }
            } else {
                scheduleInfo.setStartDate(ZonedDateTime.parse(dateComponents[1]));
                if (DeadlineHelper.isDuration(dateComponents[2])) {
                    scheduleInfo.setDuration(DeadlineHelper.parseDuration(dateComponents[2]));
                } else {
                    scheduleInfo.setEndDate(ZonedDateTime.parse(dateComponents[2]));
                }
            }
        } else if (DeadlineHelper.isDuration(dateComponents[0])) {
            scheduleInfo.setDuration(DeadlineHelper.parseDuration(dateComponents[0]));
        } else {
            scheduleInfo.setEndDate(ZonedDateTime.parse(dateComponents[0]));
        }
        return scheduleInfo;
    }

    static Duration parseDuration(String text) {
        int indexOf = text.indexOf(84);
        Duration result = indexOf == 1 ? Duration.parse(text) : (indexOf == -1 ? DeadlineHelper.getDuration(Period.parse(text), Duration.ZERO) : DeadlineHelper.getDuration(Period.parse(text.substring(0, indexOf)), Duration.parse("P" + text.substring(indexOf))));
        return result;
    }

    protected static Duration getDuration(Period p, Duration d) {
        OffsetDateTime now = OffsetDateTime.now();
        return Duration.between(now, now.plus(p).plus(d));
    }

    private static boolean isDuration(String timeStr) {
        return timeStr.startsWith("P");
    }

    private static int numRepetitions(String repetitionStr) {
        return repetitionStr.length() > 1 ? Integer.parseInt(repetitionStr.substring(1)) : -1;
    }

    private static Map<String, Object> asMap(String text) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String str : text.split("\\|")) {
            int indexOf = str.indexOf(58);
            String value = str.substring(indexOf + 1);
            if (value.trim().isEmpty()) continue;
            result.put(str.substring(0, indexOf), value);
        }
        return result;
    }

    private static Reassignment parseReassigment(String text) {
        Map<String, Object> map = DeadlineHelper.asMap(text);
        return new Reassignment(DeadlineHelper.parseSet(map.get("users")), DeadlineHelper.parseSet(map.get("groups")));
    }

    private static Set<String> parseSet(Object text) {
        return text instanceof String ? listSeparatorPattern.splitAsStream(text.toString()).collect(Collectors.toSet()) : Collections.emptySet();
    }

    private static long getDuration(ScheduleInfo info) {
        if (info.getDuration() == null) {
            throw new IllegalArgumentException("Missing duration specification for " + info);
        }
        return info.getDuration().toMillis();
    }
}

