/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.jbpm.workflow.core.impl.InputExpressionAssignment;
import org.jbpm.workflow.core.impl.OutputExpressionAssignment;
import org.jbpm.workflow.core.node.Assignment;

public class IOSpecification
implements Serializable {
    private static final long serialVersionUID = 7380526115340461267L;
    private List<DataDefinition> dataInputs = new ArrayList<DataDefinition>();
    private List<DataDefinition> dataOutputs = new ArrayList<DataDefinition>();
    private List<DataAssociation> dataInputAssociation = new ArrayList<DataAssociation>();
    private List<DataAssociation> dataOutputAssociation = new ArrayList<DataAssociation>();

    public List<DataDefinition> getDataInputs() {
        return this.dataInputs;
    }

    public Map<String, String> getInputTypes() {
        return this.getDataInputs().stream().collect(Collectors.toMap(DataDefinition::getLabel, DataDefinition::getType));
    }

    public Map<String, String> getOutputTypes() {
        return this.getDataOutputs().stream().collect(Collectors.toMap(DataDefinition::getLabel, DataDefinition::getType));
    }

    public List<DataDefinition> getDataOutputs() {
        return this.dataOutputs;
    }

    public Map<String, DataDefinition> getDataInput() {
        return this.dataInputs.stream().collect(Collectors.toMap(DataDefinition::getId, Function.identity()));
    }

    public Map<String, DataDefinition> getDataOutput() {
        return this.dataOutputs.stream().collect(Collectors.toMap(DataDefinition::getId, Function.identity()));
    }

    public List<DataAssociation> getDataInputAssociation() {
        return this.dataInputAssociation;
    }

    public List<DataAssociation> getDataOutputAssociation() {
        return this.dataOutputAssociation;
    }

    public String toString() {
        return "IOSpecification [dataInputs=" + this.dataInputs + ", dataOutputs=" + this.dataOutputs + ", dataInputAssociation=" + this.dataInputAssociation + ", dataOutputAssociation=" + this.dataOutputAssociation + "]";
    }

    public Map<String, String> getInputMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (DataAssociation da : this.dataInputAssociation) {
            if (da.getAssignments().isEmpty()) {
                mapping.put(da.getTarget().getLabel(), da.getSources().get(0).getLabel());
                continue;
            }
            if (da.getAssignments().get(0).getDialect() != null) continue;
            mapping.put(da.getAssignments().get(0).getTo().getLabel(), da.getAssignments().get(0).getFrom().getExpression());
        }
        return mapping;
    }

    public Map<String, String> getOutputMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (DataAssociation da : this.dataOutputAssociation) {
            if (da.getAssignments().isEmpty()) {
                mapping.put(da.getTarget().getLabel(), da.getSources().get(0).getLabel());
                continue;
            }
            if (da.getAssignments().get(0).getDialect() != null) continue;
            mapping.put(da.getAssignments().get(0).getTo().getExpression(), da.getAssignments().get(0).getFrom().getLabel());
        }
        return mapping;
    }

    public Map<String, String> getOutputMappingBySources() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (DataAssociation da : this.dataOutputAssociation) {
            if (da.getAssignments().isEmpty()) {
                mapping.put(da.getSources().get(0).getLabel(), da.getTarget().getLabel());
                continue;
            }
            if (da.getAssignments().get(0).getDialect() != null) continue;
            mapping.put(da.getAssignments().get(0).getFrom().getLabel(), da.getAssignments().get(0).getTo().getExpression());
        }
        return mapping;
    }

    public void addInputMapping(String source, String target) {
        DataDefinition defSource = DataDefinition.toSimpleDefinition(source);
        DataDefinition defTarget = DataDefinition.toSimpleDefinition(target);
        this.dataInputs.add(defTarget);
        if (defSource.hasExpression()) {
            this.dataInputAssociation.add(new DataAssociation(this.buildAssigment(new Assignment(null, defSource, defTarget))));
        } else {
            this.dataInputAssociation.add(new DataAssociation(defSource, defTarget, null, null));
        }
    }

    public void addOutputMapping(String source, String target) {
        DataDefinition defSource = DataDefinition.toSimpleDefinition(source);
        DataDefinition defTarget = DataDefinition.toSimpleDefinition(target);
        this.dataOutputs.add(defSource);
        if (defSource.hasExpression() || defTarget.hasExpression()) {
            this.dataOutputAssociation.add(new DataAssociation(this.buildAssigment(new Assignment(null, defSource, defTarget))));
        } else {
            this.dataOutputAssociation.add(new DataAssociation(defSource, defTarget, null, null));
        }
    }

    private Assignment buildAssigment(Assignment assignment) {
        if (assignment.getFrom().hasExpression()) {
            assignment.setMetaData("Action", new InputExpressionAssignment(assignment.getFrom(), assignment.getTo()));
        } else if (assignment.getTo().hasExpression()) {
            assignment.setMetaData("Action", new OutputExpressionAssignment(assignment.getFrom(), assignment.getTo()));
        }
        return assignment;
    }

    public boolean containsInputLabel(String label) {
        return this.dataInputs.stream().anyMatch(e -> e.getLabel().equals(label));
    }

    public boolean containsOutputLabel(String label) {
        return this.dataOutputs.stream().anyMatch(e -> e.getLabel().equals(label));
    }
}

