/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.process.instance.impl.ContextInstanceFactoryRegistry;
import org.jbpm.workflow.core.impl.NodeIoHelper;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.jbpm.workflow.instance.rule.RuleType;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;

public class RuleSetNodeInstance
extends StateBasedNodeInstance
implements EventListener,
ContextInstanceContainer {
    private static final long serialVersionUID = 510L;
    private static final String ACT_AS_WAIT_STATE_PROPERTY = "org.jbpm.rule.task.waitstate";
    private Map<String, FactHandle> factHandles = new HashMap<String, FactHandle>();
    private String ruleFlowGroup;
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();

    public RuleSetNode getRuleSetNode() {
        return (RuleSetNode)this.getNode();
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        try {
            super.internalTrigger(from, type);
            if (this.getNodeInstanceContainer().getNodeInstance(this.getStringId()) == null) {
                return;
            }
            if (!"DROOLS_DEFAULT".equals(type)) {
                throw new IllegalArgumentException("A RuleSetNode only accepts default incoming connections!");
            }
            RuleSetNode ruleSetNode = this.getRuleSetNode();
            RuleType ruleType = ruleSetNode.getRuleType();
            if (ruleType == null) {
                throw new UnsupportedOperationException("Unsupported Rule Type: " + ruleType);
            }
            ruleType.evaluate(this);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleException(Throwable e) {
        ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", e);
        if (exceptionScopeInstance == null) {
            throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute Action: " + e.getMessage(), e);
        }
        exceptionScopeInstance.handleException(e, this.getProcessContext(e));
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addRuleSetListener();
    }

    private String getRuleSetEventType() {
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        if (kruntime instanceof StatefulKnowledgeSession) {
            return "RuleFlowGroup_" + this.getRuleFlowGroup() + "_" + ((StatefulKnowledgeSession)kruntime).getIdentifier();
        }
        return "RuleFlowGroup_" + this.getRuleFlowGroup();
    }

    public void addRuleSetListener() {
        this.getProcessInstance().addEventListener(this.getRuleSetEventType(), this, true);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener(this.getRuleSetEventType(), this, true);
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.actAsWaitState()) {
            ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).getAgendaGroupsManager().deactivateRuleFlowGroup(this.getRuleFlowGroup());
        }
    }

    @Override
    public void signalEvent(String type, Object event) {
        if (this.getRuleSetEventType().equals(type)) {
            this.removeEventListeners();
            KieRuntime kruntime = Optional.ofNullable(this.getRuleSetNode().getKieRuntime()).orElse(() -> this.getProcessInstance().getKnowledgeRuntime()).get();
            this.retractFacts(kruntime);
            this.triggerCompleted();
        }
    }

    public void addFact(String key, FactHandle handle) {
        this.factHandles.put(key, handle);
    }

    public void retractFacts(KieRuntime kruntime) {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        for (Map.Entry<String, FactHandle> entry : this.factHandles.entrySet()) {
            Object object = kruntime.getObject(entry.getValue());
            String key = entry.getKey();
            key = key.replaceAll(this.getRuleFlowGroup() + "_", "");
            key = key.replaceAll(this.getProcessInstance().getStringId() + "_", "");
            objects.put(key, object);
            kruntime.delete(entry.getValue());
        }
        NodeIoHelper.processOutputs(this, objects::get, this::getVariable);
        this.factHandles.clear();
    }

    public String getRuleFlowGroup() {
        if (this.ruleFlowGroup == null || this.ruleFlowGroup.trim().length() == 0) {
            RuleType ruleType = this.getRuleSetNode().getRuleType();
            this.ruleFlowGroup = ruleType.isRuleFlowGroup() ? ruleType.getName() : null;
        }
        return this.ruleFlowGroup;
    }

    public void setRuleFlowGroup(String ruleFlowGroup) {
        this.ruleFlowGroup = this.resolveExpression(ruleFlowGroup);
    }

    public boolean actAsWaitState() {
        Object asWaitState = this.getProcessInstance().getKnowledgeRuntime().getEnvironment().get(ACT_AS_WAIT_STATE_PROPERTY);
        if (asWaitState != null) {
            return Boolean.parseBoolean(asWaitState.toString());
        }
        return false;
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        List list = this.subContextInstances.computeIfAbsent(contextId, key -> new ArrayList());
        list.add(contextInstance);
    }

    @Override
    public void removeContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list != null) {
            list.remove(contextInstance);
        }
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> contextInstances = this.subContextInstances.get(contextId);
        if (contextInstances != null) {
            for (ContextInstance contextInstance : contextInstances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(Context context) {
        ContextInstanceFactory conf = ContextInstanceFactoryRegistry.INSTANCE.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this.getProcessInstance());
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.getRuleSetNode();
    }
}

