/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import java.util.function.Function;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.event.impl.JacksonEventConsumer;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventConsumer<D, M extends Model, T extends AbstractProcessDataEvent<D>>
extends JacksonEventConsumer<M> {
    private static final Logger logger = LoggerFactory.getLogger(CloudEventConsumer.class);
    private Function<D, M> function;
    private final Class<D> dataEventClass;
    private Class<T> cloudEventClass;

    public CloudEventConsumer(Function<D, M> function, Class<D> dataEventClass, Class<T> cloudEventClass, ObjectMapper mapper) {
        super(mapper);
        this.function = function;
        this.dataEventClass = dataEventClass;
        this.cloudEventClass = cloudEventClass;
    }

    public void consume(Application application, Process<M> process, String payload, String trigger) {
        String simpleName = this.cloudEventClass.getSimpleName();
        try {
            AbstractProcessDataEvent cloudEvent = (AbstractProcessDataEvent)this.mapper.readValue(payload, this.cloudEventClass);
            Model model = (Model)this.function.apply(cloudEvent.getData());
            if (this.ignoredMessageType(cloudEvent, simpleName) && this.ignoredMessageType(cloudEvent, trigger)) {
                logger.warn("Consumer for CloudEvent type '{}', trigger '{}': ignoring message with type '{}',  source '{}'", new Object[]{simpleName, trigger, cloudEvent.getType(), cloudEvent.getSource()});
                return;
            }
            UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)application.unitOfWorkManager(), () -> {
                if (cloudEvent.getKogitoReferenceId() != null && !cloudEvent.getKogitoReferenceId().isEmpty()) {
                    logger.debug("Received message with reference id '{}' going to use it to send signal '{}'", (Object)cloudEvent.getKogitoReferenceId(), (Object)trigger);
                    Optional instance = process.instances().findById(cloudEvent.getKogitoReferenceId());
                    if (instance.isPresent()) {
                        ((ProcessInstance)instance.get()).send(Sig.of("Message-" + trigger, cloudEvent.getData(), cloudEvent.getKogitoProcessinstanceId()));
                    } else {
                        logger.warn("Process instance with id '{}' not found for triggering signal '{}'", (Object)cloudEvent.getKogitoReferenceId(), (Object)trigger);
                    }
                } else {
                    logger.debug("Received message without reference id, starting new process instance with trigger '{}'", (Object)trigger);
                    ProcessInstance pi = process.createInstance((Object)model);
                    if (cloudEvent.getKogitoStartFromNode() != null && !cloudEvent.getKogitoStartFromNode().isEmpty()) {
                        pi.startFrom(cloudEvent.getKogitoStartFromNode(), cloudEvent.getKogitoProcessinstanceId());
                    } else {
                        pi.start(trigger, cloudEvent.getKogitoProcessinstanceId());
                    }
                }
                return null;
            });
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to process JSON content for CloudEvent type: '{}', trigger: '{}': payload: '{}', error: '{}'", new Object[]{simpleName, trigger, payload, e.getMessage()});
            throw new IllegalStateException(e);
        }
    }

    private boolean ignoredMessageType(T cloudEvent, String type) {
        return !type.equals(cloudEvent.getType()) && !type.equals(cloudEvent.getSource());
    }
}

