/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.MVELProcessHelper;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.SimpleValueResolver;

public class ForEachNodeInstance
extends CompositeContextNodeInstance {
    private static final long serialVersionUID = 510L;
    private static final String TEMP_OUTPUT_VAR = "foreach_output";

    public ForEachNode getForEachNode() {
        return (ForEachNode)this.getNode();
    }

    @Override
    public NodeInstance getNodeInstance(Node node) {
        if (node instanceof ForEachNode.ForEachSplitNode) {
            ForEachSplitNodeInstance nodeInstance = new ForEachSplitNodeInstance();
            nodeInstance.setNodeId(node.getId());
            nodeInstance.setNodeInstanceContainer(this);
            nodeInstance.setProcessInstance(this.getProcessInstance());
            String uniqueID = (String)node.getMetaData().get("UniqueId");
            if (uniqueID == null) {
                uniqueID = node.getId() + "";
            }
            int level = this.getLevelForNode(uniqueID);
            nodeInstance.setLevel(level);
            return nodeInstance;
        }
        if (node instanceof ForEachNode.ForEachJoinNode) {
            ForEachJoinNodeInstance nodeInstance = (ForEachJoinNodeInstance)this.getFirstNodeInstance(node.getId());
            if (nodeInstance == null) {
                nodeInstance = new ForEachJoinNodeInstance();
                nodeInstance.setNodeId(node.getId());
                nodeInstance.setNodeInstanceContainer(this);
                nodeInstance.setProcessInstance(this.getProcessInstance());
                String uniqueID = (String)node.getMetaData().get("UniqueId");
                if (uniqueID == null) {
                    uniqueID = node.getId() + "";
                }
                int level = this.getLevelForNode(uniqueID);
                nodeInstance.setLevel(level);
            }
            return nodeInstance;
        }
        return super.getNodeInstance(node);
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.getForEachNode().getCompositeNode();
    }

    private Collection<?> evaluateCollectionExpression(String collectionExpression) {
        Object collection;
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", collectionExpression);
        if (variableScopeInstance != null) {
            collection = variableScopeInstance.getVariable(collectionExpression);
        } else {
            try {
                collection = MVELProcessHelper.evaluator().eval(collectionExpression, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Could not find collection " + collectionExpression);
            }
        }
        if (collection == null) {
            return Collections.emptyList();
        }
        if (collection instanceof Collection) {
            return (Collection)collection;
        }
        if (collection.getClass().isArray()) {
            ArrayList list = new ArrayList();
            Collections.addAll(list, (Object[])collection);
            return list;
        }
        throw new IllegalArgumentException("Unexpected collection type: " + collection.getClass());
    }

    @Override
    public ContextInstance getContextInstance(String contextId) {
        ContextInstance contextInstance = super.getContextInstance(contextId);
        if (contextInstance == null) {
            contextInstance = this.resolveContextInstance(contextId, TEMP_OUTPUT_VAR);
            this.setContextInstance(contextId, contextInstance);
        }
        return contextInstance;
    }

    @Override
    public int getLevelForNode(String uniqueID) {
        return 1;
    }

    private class ForEachNodeInstanceResolverFactory
    extends NodeInstanceResolverFactory {
        private static final long serialVersionUID = -8856846610671009685L;
        private Map<String, Object> tempVariables;

        public ForEachNodeInstanceResolverFactory(NodeInstance nodeInstance, Map<String, Object> tempVariables) {
            super(nodeInstance);
            this.tempVariables = tempVariables;
        }

        @Override
        public boolean isResolveable(String name) {
            boolean result = this.tempVariables.containsKey(name);
            if (result) {
                return result;
            }
            return super.isResolveable(name);
        }

        @Override
        public VariableResolver getVariableResolver(String name) {
            if (this.tempVariables.containsKey(name)) {
                return new SimpleValueResolver(this.tempVariables.get(name));
            }
            return super.getVariableResolver(name);
        }
    }

    public class ForEachJoinNodeInstance
    extends NodeInstanceImpl {
        private static final long serialVersionUID = 510L;

        public ForEachNode.ForEachJoinNode getForEachJoinNode() {
            return (ForEachNode.ForEachJoinNode)this.getNode();
        }

        @Override
        public void internalTrigger(KogitoNodeInstance from, String type) {
            this.triggerTime = new Date();
            HashMap<String, Object> tempVariables = new HashMap<String, Object>();
            VariableScopeInstance subprocessVariableScopeInstance = null;
            if (ForEachNodeInstance.this.getForEachNode().getOutputVariableName() != null) {
                subprocessVariableScopeInstance = (VariableScopeInstance)ForEachNodeInstance.this.getContextInstance("VariableScope");
                ArrayList<Object> outputCollection = (ArrayList<Object>)subprocessVariableScopeInstance.getVariable(ForEachNodeInstance.TEMP_OUTPUT_VAR);
                if (outputCollection == null) {
                    outputCollection = new ArrayList<Object>();
                }
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((NodeInstanceImpl)from).resolveContextInstance("VariableScope", ForEachNodeInstance.this.getForEachNode().getOutputVariableName());
                Object outputVariable = null;
                if (variableScopeInstance != null) {
                    outputVariable = variableScopeInstance.getVariable(ForEachNodeInstance.this.getForEachNode().getOutputVariableName());
                }
                outputCollection.add(outputVariable);
                subprocessVariableScopeInstance.setVariable(this, ForEachNodeInstance.TEMP_OUTPUT_VAR, outputCollection);
                tempVariables.put(ForEachNodeInstance.this.getForEachNode().getOutputVariableName(), outputVariable);
                String outputCollectionName = ForEachNodeInstance.this.getForEachNode().getOutputCollectionExpression();
                tempVariables.put(outputCollectionName, outputCollection);
            }
            boolean isCompletionConditionMet = this.evaluateCompletionCondition(ForEachNodeInstance.this.getForEachNode().getCompletionConditionExpression(), tempVariables);
            if (this.getNodeInstanceContainer().getNodeInstances().size() == 1 || isCompletionConditionMet) {
                String outputCollection = ForEachNodeInstance.this.getForEachNode().getOutputCollectionExpression();
                if (outputCollection != null) {
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", outputCollection);
                    Collection outputVariable = (Collection)variableScopeInstance.getVariable(outputCollection);
                    if (outputVariable != null) {
                        outputVariable.addAll((Collection)subprocessVariableScopeInstance.getVariable(ForEachNodeInstance.TEMP_OUTPUT_VAR));
                    } else {
                        outputVariable = (Collection)subprocessVariableScopeInstance.getVariable(ForEachNodeInstance.TEMP_OUTPUT_VAR);
                    }
                    variableScopeInstance.setVariable(this, outputCollection, outputVariable);
                }
                ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                if (ForEachNodeInstance.this.getForEachNode().isWaitForCompletion()) {
                    if (!"true".equals(System.getProperty("jbpm.enable.multi.con"))) {
                        this.triggerConnection(this.getForEachJoinNode().getTo());
                    } else {
                        List<Connection> connections = this.getForEachJoinNode().getOutgoingConnections("DROOLS_DEFAULT");
                        for (Connection connection : connections) {
                            this.triggerConnection(connection);
                        }
                    }
                }
            }
        }

        private boolean evaluateCompletionCondition(String expression, Map<String, Object> tempVariables) {
            if (expression == null || expression.isEmpty()) {
                return false;
            }
            try {
                Object result = MVELProcessHelper.evaluator().eval(expression, (VariableResolverFactory)new ForEachNodeInstanceResolverFactory(this, tempVariables));
                if (!(result instanceof Boolean)) {
                    throw new RuntimeException("Completion condition expression must return boolean values: " + result + " for expression " + expression);
                }
                return (Boolean)result;
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Could not evaluate completion condition  " + expression, t);
            }
        }
    }

    public class ForEachSplitNodeInstance
    extends NodeInstanceImpl {
        private static final long serialVersionUID = 510L;

        public ForEachNode.ForEachSplitNode getForEachSplitNode() {
            return (ForEachNode.ForEachSplitNode)this.getNode();
        }

        @Override
        public void internalTrigger(KogitoNodeInstance fromm, String type) {
            this.triggerTime = new Date();
            String collectionExpression = ForEachNodeInstance.this.getForEachNode().getCollectionExpression();
            Collection collection = ForEachNodeInstance.this.evaluateCollectionExpression(collectionExpression);
            ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
            if (collection.isEmpty()) {
                ForEachNodeInstance.this.triggerCompleted("DROOLS_DEFAULT", true);
            } else {
                ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>();
                for (Object o : collection) {
                    String variableName = ForEachNodeInstance.this.getForEachNode().getVariableName();
                    NodeInstance nodeInstance = ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstance(this.getForEachSplitNode().getTo().getTo());
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)nodeInstance.resolveContextInstance("VariableScope", variableName);
                    variableScopeInstance.setVariable(this, variableName, o);
                    nodeInstances.add(nodeInstance);
                }
                for (NodeInstance nodeInstance : nodeInstances) {
                    logger.debug("Triggering [{}] in multi-instance loop.", (Object)nodeInstance.getNodeId());
                    nodeInstance.trigger(this, this.getForEachSplitNode().getTo().getToType());
                }
                if (!ForEachNodeInstance.this.getForEachNode().isWaitForCompletion()) {
                    ForEachNodeInstance.this.triggerCompleted("DROOLS_DEFAULT", false);
                }
            }
        }
    }
}

