/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core;

import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.exception.ActionExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.ruleflow.core.factory.ActionNodeFactory;
import org.jbpm.ruleflow.core.factory.BoundaryEventNodeFactory;
import org.jbpm.ruleflow.core.factory.CatchLinkNodeFactory;
import org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory;
import org.jbpm.ruleflow.core.factory.DynamicNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.EventNodeFactory;
import org.jbpm.ruleflow.core.factory.EventSubProcessNodeFactory;
import org.jbpm.ruleflow.core.factory.FaultNodeFactory;
import org.jbpm.ruleflow.core.factory.ForEachNodeFactory;
import org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory;
import org.jbpm.ruleflow.core.factory.JoinFactory;
import org.jbpm.ruleflow.core.factory.MilestoneNodeFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.RuleSetNodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.StateNodeFactory;
import org.jbpm.ruleflow.core.factory.SubProcessNodeFactory;
import org.jbpm.ruleflow.core.factory.ThrowLinkNodeFactory;
import org.jbpm.ruleflow.core.factory.TimerNodeFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.jbpm.workflow.core.Connection;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.kie.api.definition.process.Node;

public abstract class RuleFlowNodeContainerFactory<T extends RuleFlowNodeContainerFactory<T, P>, P extends RuleFlowNodeContainerFactory<P, ?>>
extends NodeFactory<T, P> {
    public static final String METHOD_CONNECTION = "connection";
    public static final String METHOD_ASSOCIATION = "association";

    protected RuleFlowNodeContainerFactory(P nodeContainerFactory, NodeContainer nodeContainer, NodeContainer node, Object id) {
        super(nodeContainerFactory, nodeContainer, node, id);
    }

    public StartNodeFactory<T> startNode(long id) {
        return new StartNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public EndNodeFactory<T> endNode(long id) {
        return new EndNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public CatchLinkNodeFactory<T> catchLinkNode(long id) {
        return new CatchLinkNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public ThrowLinkNodeFactory<T> throwLinkNode(long id) {
        return new ThrowLinkNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public ActionNodeFactory<T> actionNode(long id) {
        return new ActionNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public MilestoneNodeFactory<T> milestoneNode(long id) {
        return new MilestoneNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public TimerNodeFactory<T> timerNode(long id) {
        return new TimerNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public HumanTaskNodeFactory<T> humanTaskNode(long id) {
        return new HumanTaskNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public SubProcessNodeFactory<T> subProcessNode(long id) {
        return new SubProcessNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public SplitFactory<T> splitNode(long id) {
        return new SplitFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public JoinFactory<T> joinNode(long id) {
        return new JoinFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public RuleSetNodeFactory<T> ruleSetNode(long id) {
        return new RuleSetNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public FaultNodeFactory<T> faultNode(long id) {
        return new FaultNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public EventNodeFactory<T> eventNode(long id) {
        return new EventNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public BoundaryEventNodeFactory<T> boundaryEventNode(long id) {
        return new BoundaryEventNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public CompositeContextNodeFactory<T> compositeContextNode(long id) {
        return new CompositeContextNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public ForEachNodeFactory<T> forEachNode(long id) {
        return new ForEachNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public DynamicNodeFactory<T> dynamicNode(long id) {
        return new DynamicNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public WorkItemNodeFactory<T> workItemNode(long id) {
        return new WorkItemNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public EventSubProcessNodeFactory<T> eventSubProcessNode(long id) {
        return new EventSubProcessNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public StateNodeFactory<T> stateNode(long id) {
        return new StateNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public T connection(long fromId, long toId) {
        return this.connection(fromId, toId, fromId + "_" + toId);
    }

    public T connection(long fromId, long toId, String uniqueId) {
        this.getConnection(fromId, toId, uniqueId);
        return (T)this;
    }

    public T association(long fromId, long toId, String uniqueId) {
        Connection connection = this.getConnection(fromId, toId, uniqueId);
        connection.setMetaData(METHOD_ASSOCIATION, Boolean.TRUE);
        connection.setMetaData("hidden", Boolean.TRUE);
        return (T)this;
    }

    private Connection getConnection(long fromId, long toId, String uniqueId) {
        Node from = ((NodeContainer)this.node).getNode(fromId);
        Node to = ((NodeContainer)this.node).getNode(toId);
        ConnectionImpl connection = new ConnectionImpl(from, "DROOLS_DEFAULT", to, "DROOLS_DEFAULT");
        if (uniqueId != null) {
            connection.setMetaData("UniqueId", uniqueId);
        }
        return connection;
    }

    public T exceptionHandler(String exception, ExceptionHandler exceptionHandler) {
        this.getScope("ExceptionScope", ExceptionScope.class).setExceptionHandler(exception, exceptionHandler);
        return (T)this;
    }

    public T exceptionHandler(String exception, String dialect, String action) {
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        exceptionHandler.setAction(new DroolsConsequenceAction(dialect, action));
        return this.exceptionHandler(exception, exceptionHandler);
    }

    private <S extends Context> S getScope(String scopeType, Class<S> scopeClass) {
        ContextContainer contextContainer = (ContextContainer)this.node;
        Context scope = contextContainer.getDefaultContext(scopeType);
        if (scope == null) {
            try {
                scope = (Context)scopeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException(ex);
            }
            contextContainer.addContext(scope);
            contextContainer.setDefaultContext(scope);
        }
        return (S)((Context)scopeClass.cast(scope));
    }
}

