/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jbpm.process.core.context.variable.Mappable;
import org.jbpm.process.core.event.EventTransformer;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.Trigger;
import org.kie.api.definition.process.Connection;

public class StartNode
extends ExtendedNodeImpl
implements Mappable {
    private static final String[] EVENT_TYPES = new String[]{"onExit"};
    private static final long serialVersionUID = 510L;
    private List<Trigger> triggers;
    private boolean isInterrupting;
    private List<DataAssociation> outMapping = new LinkedList<DataAssociation>();
    private Timer timer;
    private EventTransformer transformer;

    public void addTrigger(Trigger trigger) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<Trigger>();
        }
        this.triggers.add(trigger);
    }

    public void removeTrigger(Trigger trigger) {
        if (this.triggers != null) {
            this.triggers.remove(trigger);
        }
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
    }

    @Override
    public String[] getActionTypes() {
        return EVENT_TYPES;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        throw new UnsupportedOperationException("A start node [" + this.getMetaData("UniqueId") + ", " + this.getName() + "] may not have an incoming connection!");
    }

    @Override
    public void validateRemoveIncomingConnection(String type, Connection connection) {
        throw new UnsupportedOperationException("A start node [" + this.getMetaData("UniqueId") + ", " + this.getName() + "] may not have an incoming connection!");
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A start node [" + this.getMetaData("UniqueId") + ", " + this.getName() + "] only accepts default outgoing connection type!");
        }
        if (this.getTo() != null && !"true".equals(System.getProperty("jbpm.enable.multi.con"))) {
            throw new IllegalArgumentException("A start node [" + this.getMetaData("UniqueId") + ", " + this.getName() + "] cannot have more than one outgoing connection!");
        }
    }

    public boolean isInterrupting() {
        return this.isInterrupting;
    }

    public void setInterrupting(boolean isInterrupting) {
        this.isInterrupting = isInterrupting;
    }

    @Override
    public void addInMapping(String parameterName, String variableName) {
        throw new IllegalArgumentException("A start event [" + this.getMetaData("UniqueId") + ", " + this.getName() + "] does not support input mappings");
    }

    @Override
    public void setInMappings(Map<String, String> inMapping) {
        throw new IllegalArgumentException("A start event [" + this.getMetaData("UniqueId") + ", " + this.getName() + "] does not support input mappings");
    }

    @Override
    public String getInMapping(String parameterName) {
        return null;
    }

    @Override
    public Map<String, String> getInMappings() {
        return Collections.emptyMap();
    }

    @Override
    public void addInAssociation(DataAssociation dataAssociation) {
        throw new IllegalArgumentException("A start event does not support input mappings");
    }

    @Override
    public List<DataAssociation> getInAssociations() {
        return Collections.emptyList();
    }

    @Override
    public void addOutMapping(String parameterName, String variableName) {
        this.outMapping.add(new DataAssociation(parameterName, variableName, null, null));
    }

    @Override
    public void setOutMappings(Map<String, String> outMapping) {
        this.outMapping = new LinkedList<DataAssociation>();
        for (Map.Entry<String, String> entry : outMapping.entrySet()) {
            this.addOutMapping(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getOutMapping(String parameterName) {
        return this.getOutMappings().get(parameterName);
    }

    @Override
    public Map<String, String> getOutMappings() {
        HashMap<String, String> out = new HashMap<String, String>();
        for (DataAssociation assoc : this.outMapping) {
            if (assoc.getSources().size() != 1 || assoc.getAssignments() != null && assoc.getAssignments().size() != 0 || assoc.getTransformation() != null) continue;
            out.put(assoc.getSources().get(0), assoc.getTarget());
        }
        return out;
    }

    @Override
    public void addOutAssociation(DataAssociation dataAssociation) {
        this.outMapping.add(dataAssociation);
    }

    @Override
    public List<DataAssociation> getOutAssociations() {
        return Collections.unmodifiableList(this.outMapping);
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void setEventTransformer(EventTransformer transformer) {
        this.transformer = transformer;
    }

    public EventTransformer getEventTransformer() {
        return this.transformer;
    }
}

