/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import java.util.Optional;
import java.util.function.Function;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.kogito.services.event.EventConsumer;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventConsumer<D, M extends Model, T extends AbstractProcessDataEvent<D>>
implements EventConsumer<M> {
    private static final Logger logger = LoggerFactory.getLogger(CloudEventConsumer.class);
    private Function<D, M> function;

    public CloudEventConsumer(Function<D, M> function) {
        this.function = function;
    }

    public void consume(Application application, Process<M> process, Object object, String trigger) {
        AbstractProcessDataEvent cloudEvent = (AbstractProcessDataEvent)object;
        Model model = (Model)this.function.apply(cloudEvent.getData());
        String simpleName = cloudEvent.getClass().getSimpleName();
        if (this.ignoredMessageType(cloudEvent, simpleName) && this.ignoredMessageType(cloudEvent, trigger)) {
            logger.warn("Consumer for CloudEvent type '{}', trigger '{}': ignoring message with type '{}',  source '{}'", new Object[]{simpleName, trigger, cloudEvent.getType(), cloudEvent.getSource()});
            return;
        }
        UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)application.unitOfWorkManager(), () -> {
            if (cloudEvent.getKogitoReferenceId() != null && !cloudEvent.getKogitoReferenceId().isEmpty()) {
                logger.debug("Received message with reference id '{}' going to use it to send signal '{}'", (Object)cloudEvent.getKogitoReferenceId(), (Object)trigger);
                Optional instance = process.instances().findById(cloudEvent.getKogitoReferenceId());
                if (instance.isPresent()) {
                    ((ProcessInstance)instance.get()).send(Sig.of("Message-" + trigger, cloudEvent.getData(), cloudEvent.getKogitoProcessinstanceId()));
                } else {
                    logger.warn("Process instance with id '{}' not found for triggering signal '{}', starting a new one", (Object)cloudEvent.getKogitoReferenceId(), (Object)trigger);
                    this.startNewInstance(process, model, cloudEvent, trigger);
                }
            } else {
                logger.debug("Received message without reference id, starting new process instance with trigger '{}'", (Object)trigger);
                this.startNewInstance(process, model, cloudEvent, trigger);
            }
            return null;
        });
    }

    private void startNewInstance(Process<M> process, M model, T cloudEvent, String trigger) {
        ProcessInstance pi = process.createInstance(model);
        if (cloudEvent.getKogitoStartFromNode() != null && !cloudEvent.getKogitoStartFromNode().isEmpty()) {
            pi.startFrom(cloudEvent.getKogitoStartFromNode(), cloudEvent.getKogitoProcessinstanceId());
        } else {
            pi.start(trigger, cloudEvent.getKogitoProcessinstanceId());
        }
    }

    private boolean ignoredMessageType(T cloudEvent, String type) {
        return !type.equals(cloudEvent.getType()) && !type.equals(cloudEvent.getSource());
    }
}

