/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import java.util.function.Function;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.services.event.EventConsumer;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEventConsumer<D, M extends Model>
implements EventConsumer<M> {
    private static final Logger logger = LoggerFactory.getLogger(DataEventConsumer.class);
    private Function<D, M> function;

    public DataEventConsumer(Function<D, M> function) {
        this.function = function;
    }

    public void consume(Application application, Process<M> process, Object eventData, String trigger) {
        Model model = (Model)this.function.apply(eventData);
        UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)application.unitOfWorkManager(), () -> {
            logger.debug("Received message without reference id, staring new process instance with trigger '{}'", (Object)trigger);
            ProcessInstance pi = process.createInstance((Object)model);
            pi.start(trigger, null);
            return null;
        });
    }
}

