/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.jbpm.process.instance.impl.AbstractReturnValueEvaluator;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;

public class XPATHReturnValueEvaluator
extends AbstractReturnValueEvaluator {
    public XPATHReturnValueEvaluator() {
        super("XPath", "true()");
    }

    public XPATHReturnValueEvaluator(String expression) {
        super("XPath", expression);
    }

    @Override
    public Object evaluate(final KogitoProcessContext context) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpathEvaluator = factory.newXPath();
            xpathEvaluator.setXPathFunctionResolver(new XPathFunctionResolver(){

                @Override
                public XPathFunction resolveFunction(QName functionName, int arity) {
                    String localName = functionName.getLocalPart();
                    if ("getVariable".equals(localName)) {
                        return new GetVariableData();
                    }
                    throw new IllegalArgumentException("Unknown BPMN function: " + functionName);
                }

                class GetVariableData
                implements XPathFunction {
                    GetVariableData() {
                    }

                    public Object evaluate(List args) throws XPathFunctionException {
                        String varname = (String)args.get(0);
                        return context.getVariable(varname);
                    }
                }
            });
            xpathEvaluator.setXPathVariableResolver(new XPathVariableResolver(){

                @Override
                public Object resolveVariable(QName variableName) {
                    return context.getVariable(variableName.getLocalPart());
                }
            });
            xpathEvaluator.setNamespaceContext(new NamespaceContext(){
                private static final String DROOLS_NAMESPACE_URI = "http://www.jboss.org/drools";
                private String[] prefixes = new String[]{"drools", "bpmn2"};

                public Iterator getPrefixes(String namespaceURI) {
                    return Arrays.asList(this.prefixes).iterator();
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    if (DROOLS_NAMESPACE_URI.equalsIgnoreCase(namespaceURI)) {
                        return "bpmn2";
                    }
                    return null;
                }

                @Override
                public String getNamespaceURI(String prefix) {
                    if ("bpmn2".equalsIgnoreCase(prefix)) {
                        return DROOLS_NAMESPACE_URI;
                    }
                    return null;
                }
            });
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return xpathEvaluator.evaluate(this.expression, builder.newDocument(), XPathConstants.BOOLEAN);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

