/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.humantask;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.impl.humantask.InternalHumanTaskWorkItem;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.definition.process.WorkflowElementIdentifier;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.Policy;

public class HumanTaskWorkItemDecoratorImpl
implements InternalHumanTaskWorkItem {
    private NodeInstance nodeInstance;
    private InternalHumanTaskWorkItem delegate;

    public HumanTaskWorkItemDecoratorImpl(NodeInstance nodeInstance, InternalHumanTaskWorkItem delegate) {
        this.nodeInstance = nodeInstance;
        this.delegate = delegate;
    }

    private InternalKnowledgeRuntime getKieRuntime() {
        return ((WorkflowProcessInstanceImpl)this.nodeInstance.getProcessInstance()).getKnowledgeRuntime();
    }

    private Optional<KogitoProcessEventSupport> getEventSupport() {
        if (!this.isActive()) {
            return Optional.empty();
        }
        if (this.getKieRuntime() == null) {
            return Optional.empty();
        }
        if (this.getKieRuntime().getProcessRuntime() == null) {
            return Optional.empty();
        }
        return Optional.of(InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getKieRuntime().getProcessRuntime()).getProcessEventSupport());
    }

    private boolean isActive() {
        return this.nodeInstance.getProcessInstance() != null && this.getKieRuntime() != null;
    }

    public String getTaskName() {
        return this.delegate.getTaskName();
    }

    public String getTaskDescription() {
        return this.delegate.getTaskDescription();
    }

    public String getTaskPriority() {
        return this.delegate.getTaskPriority();
    }

    public String getReferenceName() {
        return this.delegate.getReferenceName();
    }

    public String getActualOwner() {
        return this.delegate.getActualOwner();
    }

    public Set<String> getPotentialUsers() {
        return this.delegate.getPotentialUsers();
    }

    public Set<String> getPotentialGroups() {
        return this.delegate.getPotentialGroups();
    }

    public Set<String> getAdminUsers() {
        return this.delegate.getAdminUsers();
    }

    public Set<String> getAdminGroups() {
        return this.delegate.getAdminGroups();
    }

    public Set<String> getExcludedUsers() {
        return this.delegate.getExcludedUsers();
    }

    public void setId(String uuid) {
        this.delegate.setId(uuid);
    }

    @Override
    public void setAttachment(String id, Attachment attachment) {
        Attachment oldValue = (Attachment)this.delegate.getAttachments().get(id);
        this.delegate.setAttachment(id, attachment);
        if (oldValue != null) {
            this.getEventSupport().ifPresent(e -> e.fireOnUserTaskAttachmentChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), oldValue, attachment));
        } else {
            this.getEventSupport().ifPresent(e -> e.fireOnUserTaskAttachmentAdded(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), attachment));
        }
    }

    @Override
    public Attachment removeAttachment(String id) {
        Attachment oldValue = (Attachment)this.delegate.getAttachments().remove(id);
        this.getEventSupport().ifPresent(e -> e.fireOnUserTaskAttachmentDeleted(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), oldValue));
        return oldValue;
    }

    @Override
    public void setComment(String id, Comment comment) {
        Comment oldValue = (Comment)this.delegate.getComments().remove(id);
        this.delegate.setComment(id, comment);
        if (oldValue != null) {
            this.getEventSupport().ifPresent(e -> e.fireOnUserTaskCommentChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), oldValue, comment));
        } else {
            this.getEventSupport().ifPresent(e -> e.fireOnUserTaskCommentAdded(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), comment));
        }
    }

    @Override
    public Comment removeComment(String id) {
        Comment oldValue = (Comment)this.delegate.getComments().remove(id);
        this.getEventSupport().ifPresent(e -> e.fireOnUserTaskCommentDeleted(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), oldValue));
        return oldValue;
    }

    public Map<Object, Attachment> getAttachments() {
        return this.delegate.getAttachments();
    }

    public Map<Object, Comment> getComments() {
        return this.delegate.getComments();
    }

    public long getId() {
        return this.delegate.getId();
    }

    public String getStringId() {
        return this.delegate.getStringId();
    }

    public String getProcessInstanceStringId() {
        return this.delegate.getProcessInstanceId();
    }

    public String getPhaseId() {
        return this.delegate.getPhaseId();
    }

    public String getPhaseStatus() {
        return this.delegate.getPhaseStatus();
    }

    public Date getStartDate() {
        return this.delegate.getStartDate();
    }

    public Date getCompleteDate() {
        return this.delegate.getCompleteDate();
    }

    public KogitoNodeInstance getNodeInstance() {
        return this.delegate.getNodeInstance();
    }

    public KogitoProcessInstance getProcessInstance() {
        return this.delegate.getProcessInstance();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public int getState() {
        return this.delegate.getState();
    }

    public Object getParameter(String name) {
        return this.delegate.getParameter(name);
    }

    public Map<String, Object> getParameters() {
        return this.delegate.getParameters();
    }

    public Object getResult(String name) {
        return this.delegate.getResult(name);
    }

    public Map<String, Object> getResults() {
        return this.delegate.getResults();
    }

    public String getProcessInstanceId() {
        return this.delegate.getProcessInstanceId();
    }

    public String getNodeInstanceStringId() {
        return this.delegate.getNodeInstanceStringId();
    }

    public String getDeploymentId() {
        return this.delegate.getDeploymentId();
    }

    public long getNodeInstanceId() {
        return this.delegate.getNodeInstanceId();
    }

    public WorkflowElementIdentifier getNodeId() {
        return this.delegate.getNodeId();
    }

    public void setPhaseId(String phaseId) {
        this.delegate.setPhaseId(phaseId);
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.delegate.setProcessInstanceId(processInstanceId);
    }

    public void setNodeInstanceId(String deploymentId) {
        this.delegate.setNodeInstanceId(deploymentId);
    }

    public void setPhaseStatus(String phaseStatus) {
        String oldPhaseStatus = this.delegate.getPhaseStatus();
        this.delegate.setPhaseStatus(phaseStatus);
        this.getEventSupport().ifPresent(e -> e.fireOneUserTaskStateChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), oldPhaseStatus, phaseStatus));
    }

    public void setStartDate(Date date) {
        this.delegate.setStartDate(date);
    }

    public void setCompleteDate(Date date) {
        this.delegate.setCompleteDate(date);
    }

    public void setNodeInstance(KogitoNodeInstance nodeInstance) {
        this.delegate.setNodeInstance(nodeInstance);
    }

    public void setProcessInstance(KogitoProcessInstance processInstance) {
        this.delegate.setProcessInstance(processInstance);
    }

    public void setName(String name) {
        this.delegate.setName(name);
    }

    public void setParameter(String name, Object value) {
        Object oldValue = this.delegate.getParameter(name);
        this.delegate.setParameter(name, value);
        this.getEventSupport().ifPresent(e -> e.fireOnUserTaskInputVariableChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), name, value, oldValue));
    }

    public void setParameters(Map<String, Object> parameters) {
        parameters.forEach(this::setParameter);
    }

    public void setResults(Map<String, Object> results) {
        if (results != null) {
            results.forEach(this::setResult);
        } else {
            HashMap outcome = new HashMap(this.delegate.getResults());
            this.delegate.setResults(null);
            if (this.isActive()) {
                for (String key : outcome.keySet()) {
                    this.getEventSupport().ifPresent(e -> e.fireOnUserTaskOutputVariableChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), key, null, outcome.get(key)));
                }
            }
        }
    }

    public void setResult(String name, Object value) {
        Object oldValue = this.delegate.getParameter(name);
        this.delegate.setResult(name, value);
        if (this.isActive()) {
            this.getEventSupport().ifPresent(e -> e.fireOnUserTaskOutputVariableChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), name, value, oldValue));
        }
    }

    public void setState(int state) {
        this.delegate.setState(state);
    }

    public void setDeploymentId(String deploymentId) {
        this.delegate.setDeploymentId(deploymentId);
    }

    public void setNodeInstanceId(long deploymentId) {
        this.delegate.setNodeInstanceId(deploymentId);
    }

    public void setNodeId(WorkflowElementIdentifier nodeIdentifier) {
        this.delegate.setNodeId(nodeIdentifier);
    }

    @Override
    public void setTaskName(String taskName) {
        this.delegate.setTaskName(taskName);
    }

    @Override
    public void setTaskDescription(String taskDescription) {
        this.delegate.setTaskDescription(taskDescription);
        if (this.delegate.getPhaseStatus() == null) {
            return;
        }
        this.getEventSupport().ifPresent(e -> e.fireOneUserTaskStateChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), this.delegate.getPhaseStatus(), this.delegate.getPhaseStatus()));
    }

    @Override
    public void setTaskPriority(String taskPriority) {
        this.delegate.setTaskPriority(taskPriority);
        if (this.delegate.getPhaseStatus() == null) {
            return;
        }
        this.getEventSupport().ifPresent(e -> e.fireOneUserTaskStateChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), this.delegate.getPhaseStatus(), this.delegate.getPhaseStatus()));
    }

    @Override
    public void setReferenceName(String referenceName) {
        this.delegate.setReferenceName(referenceName);
    }

    @Override
    public void setActualOwner(String actualOwner) {
        String currentPhaseStatus = this.delegate.getPhaseStatus();
        this.delegate.setActualOwner(actualOwner);
        if (currentPhaseStatus == null) {
            return;
        }
        this.getEventSupport().ifPresent(e -> e.fireOneUserTaskStateChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), currentPhaseStatus, currentPhaseStatus));
    }

    @Override
    public void setPotentialUsers(Set<String> potentialUsers) {
        HashSet oldValue = new HashSet(this.delegate.getPotentialUsers());
        this.delegate.setPotentialUsers(potentialUsers);
        this.getEventSupport().ifPresent(e -> e.fireOnUserTaskAssignmentChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), KogitoProcessEventSupport.AssignmentType.USER_OWNERS, oldValue, potentialUsers));
    }

    @Override
    public void setPotentialGroups(Set<String> potentialGroups) {
        HashSet oldValue = new HashSet(this.delegate.getPotentialGroups());
        this.delegate.setPotentialGroups(potentialGroups);
        this.getEventSupport().ifPresent(e -> e.fireOnUserTaskAssignmentChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), KogitoProcessEventSupport.AssignmentType.USER_GROUPS, oldValue, potentialGroups));
    }

    @Override
    public void setAdminGroups(Set<String> potentialAdmins) {
        HashSet oldValue = new HashSet(this.delegate.getAdminGroups());
        this.delegate.setAdminGroups(potentialAdmins);
        this.getEventSupport().ifPresent(e -> e.fireOnUserTaskAssignmentChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), KogitoProcessEventSupport.AssignmentType.ADMIN_GROUPS, oldValue, potentialAdmins));
    }

    @Override
    public void setAdminUsers(Set<String> adminUsers) {
        HashSet oldValue = new HashSet(this.delegate.getAdminUsers());
        this.delegate.setAdminUsers(adminUsers);
        this.getEventSupport().ifPresent(e -> e.fireOnUserTaskAssignmentChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), KogitoProcessEventSupport.AssignmentType.ADMIN_USERS, oldValue, adminUsers));
    }

    @Override
    public void setExcludedUsers(Set<String> excludedUsers) {
        HashSet oldValue = new HashSet(this.delegate.getExcludedUsers());
        this.delegate.setExcludedUsers(excludedUsers);
        this.getEventSupport().ifPresent(e -> e.fireOnUserTaskAssignmentChange(this.getProcessInstance(), this.getNodeInstance(), (KieRuntime)this.getKieRuntime(), KogitoProcessEventSupport.AssignmentType.USERS_EXCLUDED, oldValue, excludedUsers));
    }

    public boolean enforce(Policy<?> ... policies) {
        return this.delegate.enforce(policies);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

