/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core;

import java.util.UUID;
import org.kie.api.definition.process.WorkflowElementIdentifier;

public class WorkflowElementIdentifierFactory
implements WorkflowElementIdentifier {
    private String elementId;

    public static WorkflowElementIdentifier fromExternalFormat(Long elementId) {
        return WorkflowElementIdentifierFactory.fromExternalFormat(String.valueOf(elementId));
    }

    public static WorkflowElementIdentifier fromExternalFormat(String elementId) {
        return new WorkflowElementIdentifierFactory(elementId);
    }

    public static WorkflowElementIdentifier newRandom() {
        return new WorkflowElementIdentifierFactory("jbpm-" + UUID.randomUUID().toString());
    }

    public WorkflowElementIdentifierFactory(String elementId) {
        this.elementId = elementId;
    }

    public <T> T toValue() {
        return (T)this.elementId;
    }

    public String toString() {
        return "[uuid=" + this.elementId + "]";
    }

    public int hashCode() {
        return this.elementId.hashCode();
    }

    public String toExternalFormat() {
        return this.elementId;
    }

    public int compareTo(WorkflowElementIdentifier o) {
        return this.elementId.compareTo(((WorkflowElementIdentifierFactory)o).elementId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkflowElementIdentifierFactory other = (WorkflowElementIdentifierFactory)obj;
        return this.elementId.equals(other.elementId);
    }

    public String toSanitizeString() {
        return this.toExternalFormat().replaceAll("-", "_");
    }
}

