/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import java.util.Collections;
import java.util.Map;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.kie.api.definition.process.WorkflowElementIdentifier;

public abstract class AbstractCompositeNodeFactory<T extends RuleFlowNodeContainerFactory<T, P>, P extends RuleFlowNodeContainerFactory<P, ?>>
extends RuleFlowNodeContainerFactory<T, P> {
    private WorkflowElementIdentifier linkedIncomingNodeId;
    private WorkflowElementIdentifier linkedOutgoingNodeId;

    protected AbstractCompositeNodeFactory(P nodeContainerFactory, NodeContainer nodeContainer, Node node, WorkflowElementIdentifier id) {
        super(nodeContainerFactory, nodeContainer, node, id);
    }

    @Override
    protected NodeContainer getNodeContainer() {
        return this.getCompositeNode();
    }

    protected CompositeContextNode getCompositeNode() {
        return (CompositeContextNode)this.node;
    }

    public T timeout(String timeout) {
        this.getCompositeNode().setTimeout(timeout);
        return (T)this;
    }

    @Override
    public T variable(String name, DataType type) {
        return this.variable(name, type, Collections.emptyMap());
    }

    @Override
    public T variable(String name, DataType type, Object value) {
        return this.variable(name, type, value, Collections.emptyMap());
    }

    @Override
    public T variable(String name, DataType type, Map<String, Object> metaData) {
        return this.variable(name, type, null, metaData);
    }

    @Override
    public T variable(String name, DataType type, Object value, Map<String, Object> metadata) {
        Variable variable = new Variable();
        variable.setName(name);
        variable.setType(type);
        variable.setValue(value);
        VariableScope variableScope = (VariableScope)this.getCompositeNode().getDefaultContext("VariableScope");
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            variable.setMetaData(entry.getKey(), entry.getValue());
        }
        if (variableScope == null) {
            variableScope = new VariableScope();
            this.getCompositeNode().addContext(variableScope);
            this.getCompositeNode().setDefaultContext(variableScope);
        }
        variableScope.getVariables().add(variable);
        return (T)this;
    }

    public T linkIncomingConnections(WorkflowElementIdentifier nodeId) {
        this.linkedIncomingNodeId = nodeId;
        return (T)this;
    }

    public T autoComplete(boolean autoComplete) {
        this.getCompositeNode().setAutoComplete(autoComplete);
        return (T)this;
    }

    public T linkOutgoingConnections(WorkflowElementIdentifier nodeId) {
        this.linkedOutgoingNodeId = nodeId;
        return (T)this;
    }

    @Override
    public P done() {
        if (this.linkedIncomingNodeId != null) {
            this.getCompositeNode().linkIncomingConnections("DROOLS_DEFAULT", this.linkedIncomingNodeId, "DROOLS_DEFAULT");
        }
        if (this.linkedOutgoingNodeId != null) {
            this.getCompositeNode().linkOutgoingConnections(this.linkedOutgoingNodeId, "DROOLS_DEFAULT", "DROOLS_DEFAULT");
        }
        return super.done();
    }
}

