/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.provider.NodeFactoryProvider;
import org.jbpm.workflow.core.NodeContainer;
import org.kie.api.definition.process.WorkflowElementIdentifier;

public class NodeFactoryProviderService {
    List<NodeFactoryProvider> providers = new ArrayList<NodeFactoryProvider>();

    public NodeFactoryProviderService() {
        ServiceLoader.load(NodeFactoryProvider.class).forEach(this.providers::add);
    }

    public <T extends NodeFactory<T, P>, P extends RuleFlowNodeContainerFactory<P, ?>> T newNodeFactory(Class<?> type, P nodeContainerFactory, NodeContainer container, WorkflowElementIdentifier id) {
        Predicate<NodeFactoryProvider> typeFilter = provider -> provider.accept(type);
        Optional<NodeFactoryProvider> provider2 = this.providers.stream().filter(typeFilter).findAny();
        if (provider2.isEmpty()) {
            throw new IllegalArgumentException("Provider for " + type.getCanonicalName() + " not found");
        }
        return provider2.get().provide(nodeContainerFactory, container, id);
    }
}

