/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.jbpm.workflow.core.impl.InputExpressionAssignment;
import org.jbpm.workflow.core.impl.OutputExpressionAssignment;
import org.jbpm.workflow.core.impl.SimpleExpressionAssignment;
import org.jbpm.workflow.core.impl.StaticAssignment;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.Transformation;

public class DataAssociation
implements Serializable {
    private static final long serialVersionUID = 5L;
    private List<DataDefinition> sources;
    private DataDefinition target;
    private List<Assignment> assignments;
    private Transformation transformation;
    private DataAssociationType type;

    public DataAssociation(Assignment assignment) {
        this(Collections.emptyList(), null, Collections.singletonList(assignment), null);
    }

    public DataAssociation(List<DataDefinition> sources, DataDefinition target, List<Assignment> assignments, Transformation transformation) {
        this.sources = new ArrayList<DataDefinition>(sources);
        this.target = target;
        this.transformation = transformation;
        this.assignments = assignments == null ? new ArrayList() : assignments;
        this.assignments.forEach(this::buildInterpretedAssignment);
    }

    public DataAssociationType getType() {
        return this.type;
    }

    public void setType(DataAssociationType type) {
        this.type = type;
    }

    private Assignment buildInterpretedAssignment(Assignment assignment) {
        if (assignment.getDialect() != null) {
            return assignment;
        }
        if (this.isExpr(assignment.getFrom().getExpression())) {
            assignment.setMetaData("Action", new InputExpressionAssignment(assignment.getFrom(), assignment.getTo()));
        } else if (this.isExpr(assignment.getTo().getExpression())) {
            assignment.setMetaData("Action", new OutputExpressionAssignment(assignment.getFrom(), assignment.getTo()));
        } else if (assignment.getFrom().hasExpression()) {
            String source = assignment.getFrom().getExpression();
            source = this.isConstant(source) ? source.substring(1, source.length() - 1) : source;
            assignment.setMetaData("Action", new StaticAssignment(source, assignment.getTo()));
        } else {
            assignment.setMetaData("Action", new SimpleExpressionAssignment(assignment.getFrom(), assignment.getTo()));
        }
        return assignment;
    }

    private boolean isConstant(String expression) {
        return Pattern.matches("\".*\"", expression);
    }

    private boolean isExpr(String mvelExpression) {
        return mvelExpression != null && mvelExpression.contains("#{");
    }

    public DataAssociation(DataDefinition source, DataDefinition target, List<Assignment> assignments, Transformation transformation) {
        this(Collections.singletonList(source), target, assignments, transformation);
    }

    public List<DataDefinition> getSources() {
        return this.sources != null ? this.sources : Collections.emptyList();
    }

    public void setSources(List<DataDefinition> sources) {
        this.sources = sources;
    }

    public DataDefinition getTarget() {
        return this.target;
    }

    public void setTarget(DataDefinition target) {
        this.target = target;
    }

    public List<Assignment> getAssignments() {
        return this.assignments != null ? this.assignments : Collections.emptyList();
    }

    public void setAssignments(List<Assignment> assignments) {
        this.assignments = assignments;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Transformation transformation) {
        if (transformation != null) {
            throw new UnsupportedOperationException("Transformations are not supported");
        }
    }

    public String toString() {
        return "DataAssociation{sources=" + this.sources + ", target='" + this.target + "', assignments=" + this.assignments + ", transformation=" + this.transformation + "}";
    }

    public static enum DataAssociationType {
        INPUT,
        OUTPUT;

    }
}

