/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.List;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.context.AbstractContext;
import org.jbpm.process.core.impl.ContextContainerImpl;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.kie.api.definition.process.Connection;

public class WorkItemNode
extends StateBasedNode
implements ContextContainer {
    private static final long serialVersionUID = 510L;
    private ContextContainer contextContainer = new ContextContainerImpl();
    private Work work;
    private boolean waitForCompletion = true;

    public Work getWork() {
        return this.work;
    }

    public void setWork(Work work) {
        this.work = work;
    }

    public boolean isWaitForCompletion() {
        return this.waitForCompletion;
    }

    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getUniqueId() + ", " + connection.getTo().getName() + "] only accepts default incoming connection type!");
        }
        if (this.getFrom() != null && !"true".equals(System.getProperty("jbpm.enable.multi.con"))) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getUniqueId() + ", " + connection.getTo().getName() + "] cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getUniqueId() + ", " + connection.getFrom().getName() + "] only accepts default outgoing connection type!");
        }
        if (this.getTo() != null && !"true".equals(System.getProperty("jbpm.enable.multi.con"))) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getUniqueId() + ", " + connection.getFrom().getName() + "] cannot have more than one outgoing connection!");
        }
    }

    @Override
    public List<Context> getContexts(String contextType) {
        return this.contextContainer.getContexts(contextType);
    }

    @Override
    public void addContext(Context context) {
        ((AbstractContext)context).setContextContainer(this);
        this.contextContainer.addContext(context);
    }

    @Override
    public Context getContext(String contextType, long id) {
        return this.contextContainer.getContext(contextType, id);
    }

    @Override
    public void setDefaultContext(Context context) {
        ((AbstractContext)context).setContextContainer(this);
        this.contextContainer.setDefaultContext(context);
    }

    @Override
    public Context getDefaultContext(String contextType) {
        return this.contextContainer.getDefaultContext(contextType);
    }

    @Override
    public Context getContext(String contextId) {
        Context context = this.getDefaultContext(contextId);
        if (context != null) {
            return context;
        }
        return super.getContext(contextId);
    }
}

