/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.mvel.util.MVELEvaluator;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventNodeInterface;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.CompensationEventListener;
import org.jbpm.workflow.instance.impl.DummyEventListener;
import org.jbpm.workflow.instance.impl.ExtendedNodeInstanceImpl;
import org.jbpm.workflow.instance.impl.MVELProcessHelper;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceFactoryRegistry;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.ProcessInstanceResolverFactory;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.EndNodeInstance;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventSubProcessNodeInstance;
import org.jbpm.workflow.instance.node.FaultNodeInstance;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.WorkflowElementIdentifier;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.internal.process.CorrelationKey;
import org.kie.kogito.internal.process.event.KogitoEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstanceContainer;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcess;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.process.BaseEventDescription;
import org.kie.kogito.process.EventDescription;
import org.kie.kogito.process.NamedDataType;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.flexible.AdHocFragment;
import org.kie.kogito.process.flexible.ItemDescription;
import org.kie.kogito.process.flexible.Milestone;
import org.kie.kogito.timer.TimerInstance;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkflowProcessInstanceImpl
extends ProcessInstanceImpl
implements WorkflowProcessInstance {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(WorkflowProcessInstanceImpl.class);
    private final List<NodeInstance> nodeInstances = new ArrayList<NodeInstance>();
    private Map<String, List<KogitoEventListener>> eventListeners = new HashMap<String, List<KogitoEventListener>>();
    private Map<String, List<KogitoEventListener>> externalEventListeners = new HashMap<String, List<KogitoEventListener>>();
    private List<String> completedNodeIds = new ArrayList<String>();
    private List<String> activatingNodeIds;
    private Map<String, Integer> iterationLevels = new HashMap<String, Integer>();
    private int currentLevel;
    private Object faultData;
    private boolean signalCompletion = true;
    private String deploymentId;
    private String correlationKey;
    private Date startDate;
    private Date endDate;
    private String nodeIdInError;
    private String nodeInstanceIdInError;
    private String errorMessage;
    private transient Optional<Throwable> errorCause = Optional.empty();
    private int slaCompliance = 0;
    private Date slaDueDate;
    private String slaTimerId;
    private String cancelTimerId;
    private String referenceId;
    private AgendaFilter agendaFilter;
    private ProcessInstance<?> kogitoProcessInstance;

    @Override
    public NodeContainer getNodeContainer() {
        return this.getWorkflowProcess();
    }

    @Override
    public void addNodeInstance(NodeInstance nodeInstance) {
        if (nodeInstance.getStringId() == null) {
            ((NodeInstanceImpl)nodeInstance).setId(UUID.randomUUID().toString());
        }
        this.nodeInstances.add(nodeInstance);
    }

    @Override
    public int getLevelForNode(String uniqueID) {
        if (Boolean.parseBoolean(System.getProperty("jbpm.loop.level.disabled"))) {
            return 1;
        }
        Integer value = this.iterationLevels.get(uniqueID);
        if (value == null && this.currentLevel == 0) {
            value = 1;
        } else if (value == null && this.currentLevel > 0 || value != null && this.currentLevel > 0 && value > this.currentLevel) {
            value = this.currentLevel;
        } else {
            Integer n = value;
            value = value + 1;
        }
        this.iterationLevels.put(uniqueID, value);
        return value;
    }

    @Override
    public void removeNodeInstance(NodeInstance nodeInstance) {
        if (((NodeInstanceImpl)nodeInstance).isInversionOfControl()) {
            this.getKnowledgeRuntime().delete(this.getKnowledgeRuntime().getFactHandle((Object)nodeInstance));
        }
        this.nodeInstances.remove(nodeInstance);
    }

    public Collection<org.kie.api.runtime.process.NodeInstance> getNodeInstances() {
        return new ArrayList<NodeInstance>(this.getNodeInstances(false));
    }

    @Override
    public Collection<NodeInstance> getNodeInstances(boolean recursive) {
        List<NodeInstance> result = this.nodeInstances;
        if (recursive) {
            result = new ArrayList<NodeInstance>(result);
            for (NodeInstance nodeInstance : this.nodeInstances) {
                if (!(nodeInstance instanceof KogitoNodeInstanceContainer)) continue;
                result.addAll(((NodeInstanceContainer)((Object)nodeInstance)).getNodeInstances(true));
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    public Collection<KogitoNodeInstance> getKogitoNodeInstances(Predicate<KogitoNodeInstance> filter, boolean recursive) {
        ArrayList<KogitoNodeInstance> result = new ArrayList<KogitoNodeInstance>();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance instanceof KogitoNodeInstance && filter.test(nodeInstance)) {
                result.add(nodeInstance);
            }
            if (!(nodeInstance instanceof KogitoNodeInstanceContainer) || !recursive) continue;
            result.addAll(((KogitoNodeInstanceContainer)nodeInstance).getKogitoNodeInstances(filter, true));
        }
        return result;
    }

    public NodeInstance getNodeInstance(long nodeInstanceId) {
        throw new UnsupportedOperationException();
    }

    public KogitoNodeInstance getNodeInstance(String nodeInstanceId) {
        return this.getNodeInstance(nodeInstanceId, false);
    }

    @Override
    public NodeInstance getNodeInstance(String nodeInstanceId, boolean recursive) {
        return this.getNodeInstances(recursive).stream().filter(nodeInstance -> Objects.equals(nodeInstance.getStringId(), nodeInstanceId)).findFirst().orElse(null);
    }

    public List<String> getActiveNodeIds() {
        ArrayList<String> result = new ArrayList<String>();
        this.addActiveNodeIds(this, result);
        return result;
    }

    private void addActiveNodeIds(KogitoNodeInstanceContainer container, List<String> result) {
        for (org.kie.api.runtime.process.NodeInstance nodeInstance : container.getNodeInstances()) {
            result.add(((NodeImpl)nodeInstance.getNode()).getUniqueId());
            if (!(nodeInstance instanceof KogitoNodeInstanceContainer)) continue;
            this.addActiveNodeIds((KogitoNodeInstanceContainer)nodeInstance, result);
        }
    }

    @Override
    public NodeInstance getFirstNodeInstance(WorkflowElementIdentifier nodeId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!nodeInstance.getNodeId().equals((Object)nodeId) || nodeInstance.getLevel() != this.getCurrentLevel()) continue;
            return nodeInstance;
        }
        return null;
    }

    public List<NodeInstance> getNodeInstances(WorkflowElementIdentifier nodeId) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!nodeInstance.getNodeId().equals((Object)nodeId)) continue;
            result.add(nodeInstance);
        }
        return result;
    }

    public List<NodeInstance> getNodeInstances(WorkflowElementIdentifier nodeId, List<NodeInstance> currentView) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInstance : currentView) {
            if (!nodeInstance.getNodeId().equals((Object)nodeId)) continue;
            result.add(nodeInstance);
        }
        return result;
    }

    public String getBusinessKey() {
        return this.getCorrelationKey();
    }

    @Override
    public NodeInstance getNodeInstance(Node node) {
        Node actualNode = this.resolveAsync(node);
        NodeInstanceFactory conf = NodeInstanceFactoryRegistry.getInstance(this.getKnowledgeRuntime().getEnvironment()).getProcessNodeInstanceFactory(actualNode);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        NodeInstanceImpl nodeInstance = (NodeInstanceImpl)conf.getNodeInstance(actualNode, this, (org.kie.api.runtime.process.NodeInstanceContainer)this);
        if (nodeInstance == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        if (nodeInstance.isInversionOfControl()) {
            this.getKnowledgeRuntime().insert((Object)nodeInstance);
        }
        return nodeInstance;
    }

    public KogitoWorkflowProcess getWorkflowProcess() {
        return (KogitoWorkflowProcess)this.getProcess();
    }

    public Object getVariable(String name) {
        if (this.getKnowledgeRuntime() == null) {
            List<ContextInstance> variableScopeInstances = this.getContextInstances("VariableScope");
            if (variableScopeInstances != null && variableScopeInstances.size() == 1) {
                for (ContextInstance contextInstance : variableScopeInstances) {
                    Object value = ((VariableScopeInstance)contextInstance).getVariable(name);
                    if (value == null) continue;
                    return value;
                }
            }
            return null;
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            return null;
        }
        return variableScopeInstance.getVariable(name);
    }

    public Map<String, Object> getVariables() {
        if (this.getKnowledgeRuntime() == null) {
            List<ContextInstance> variableScopeInstances = this.getContextInstances("VariableScope");
            if (variableScopeInstances == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (ContextInstance contextInstance : variableScopeInstances) {
                Map<String, Object> variables = ((VariableScopeInstance)contextInstance).getVariables();
                result.putAll(variables);
            }
            return result;
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            return Collections.emptyMap();
        }
        return variableScopeInstance.getVariables();
    }

    public void setVariable(String name, Object value) {
        VariableScope variableScope = (VariableScope)((ContextContainer)this.getProcess()).getDefaultContext("VariableScope");
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            throw new IllegalArgumentException("No variable scope found.");
        }
        variableScope.validateVariable(this.getProcessName(), name, value);
        variableScopeInstance.setVariable(name, value);
    }

    @Override
    public void setState(int state, String outcome, Object faultData) {
        this.faultData = faultData;
        this.setState(state, outcome);
    }

    @Override
    public void setState(int state, String outcome) {
        if (state == 2 || state == 3) {
            this.endDate = new Date();
            if (this.slaCompliance == 1) {
                this.slaCompliance = System.currentTimeMillis() > this.slaDueDate.getTime() ? 3 : (state == 2 ? 2 : 4);
            }
            InternalKnowledgeRuntime kruntime = this.getKnowledgeRuntime();
            InternalProcessRuntime processRuntime = (InternalProcessRuntime)kruntime.getProcessRuntime();
            processRuntime.getProcessEventSupport().fireBeforeProcessCompleted((KogitoProcessInstance)this, (KieRuntime)kruntime);
            super.setState(state, outcome);
            while (!this.nodeInstances.isEmpty()) {
                NodeInstance nodeInstance = this.nodeInstances.get(0);
                nodeInstance.cancel();
            }
            WorkflowProcessInstanceImpl.cancelTimer(processRuntime, this.slaTimerId);
            WorkflowProcessInstanceImpl.cancelTimer(processRuntime, this.cancelTimerId);
            this.removeEventListeners();
            processRuntime.getProcessInstanceManager().removeProcessInstance(this);
            processRuntime.getProcessEventSupport().fireAfterProcessCompleted((KogitoProcessInstance)this, (KieRuntime)kruntime);
            if (this.isSignalCompletion()) {
                List<KogitoEventListener> listeners = this.eventListeners.get("processInstanceCompleted:" + this.getStringId());
                if (listeners != null) {
                    for (KogitoEventListener listener : listeners) {
                        listener.signalEvent("processInstanceCompleted:" + this.getStringId(), (Object)this);
                    }
                }
                processRuntime.getSignalManager().signalEvent("processInstanceCompleted:" + this.getStringId(), (Object)this);
            }
        } else {
            super.setState(state, outcome);
        }
    }

    private static void cancelTimer(InternalProcessRuntime processRuntime, String timerId) {
        if (timerId != null && !timerId.isBlank()) {
            processRuntime.getJobsService().cancelJob(timerId);
            logger.debug("Timer {} has been canceled", (Object)timerId);
        }
    }

    @Override
    public void setState(int state) {
        this.setState(state, null);
    }

    @Override
    public void disconnect() {
        this.removeEventListeners();
        this.unregisterExternalEventNodeListeners();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).removeEventListeners();
        }
        super.disconnect();
    }

    @Override
    public void reconnect() {
        super.reconnect();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).addEventListeners();
        }
        this.registerExternalEventNodeListeners();
    }

    @Override
    public String toString() {
        return "WorkflowProcessInstance" + " [Id=" + this.getStringId() + ",processId=" + this.getProcessId() + ",state=" + this.getState() + "]";
    }

    @Override
    public void start() {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String trigger) {
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = this;
        synchronized (workflowProcessInstanceImpl) {
            Node[] nodes;
            this.setStartDate(new Date());
            this.registerExternalEventNodeListeners();
            for (Node node : nodes = this.getNodeContainer().getNodes()) {
                Map<Timer, DroolsAction> timers;
                if (!(node instanceof EventSubProcessNode) || (timers = ((EventSubProcessNode)node).getTimers()) == null || timers.isEmpty()) continue;
                EventSubProcessNodeInstance eventSubProcess = (EventSubProcessNodeInstance)this.getNodeInstance(node);
                eventSubProcess.trigger(null, "DROOLS_DEFAULT");
            }
            super.start(trigger);
        }
    }

    @Override
    public void configureTimers() {
        String processDuration;
        TimerInstance timer;
        Map metadata = this.getProcess().getMetaData();
        String slaDueDateExpression = (String)metadata.get("customSLADueDate");
        if (slaDueDateExpression != null && (timer = this.configureSLATimer(slaDueDateExpression)) != null) {
            this.slaTimerId = timer.getId();
            this.slaDueDate = new Date(System.currentTimeMillis() + timer.getDelay());
            this.slaCompliance = 1;
            logger.debug("SLA for process instance {} is PENDING with due date {}", (Object)this.getStringId(), (Object)this.slaDueDate);
        }
        if ((processDuration = (String)metadata.get("processDuration")) != null) {
            this.cancelTimerId = this.registerTimer(this.createDurationTimer(Duration.parse(processDuration).toMillis())).getId();
        }
    }

    public TimerInstance configureSLATimer(String slaDueDateExpression) {
        long duration;
        if ((slaDueDateExpression = this.resolveVariable(slaDueDateExpression).toString()) == null || slaDueDateExpression.trim().isEmpty()) {
            logger.debug("Sla due date expression resolved to no value '{}'", (Object)slaDueDateExpression);
            return null;
        }
        logger.debug("SLA due date is set to {}", (Object)slaDueDateExpression);
        InternalKnowledgeRuntime kruntime = this.getKnowledgeRuntime();
        if (kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
            BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
            duration = businessCalendar.calculateBusinessTimeAsDuration(slaDueDateExpression);
        } else {
            duration = DateTimeUtils.parseDuration(slaDueDateExpression);
        }
        TimerInstance timerInstance = this.createDurationTimer(duration);
        if (this.useTimerSLATracking()) {
            this.registerTimer(timerInstance);
        }
        return timerInstance;
    }

    private TimerInstance createDurationTimer(long duration) {
        TimerInstance timerInstance = new TimerInstance();
        timerInstance.setId(UUID.randomUUID().toString());
        timerInstance.setTimerId("-1");
        timerInstance.setDelay(duration);
        timerInstance.setPeriod(0L);
        return timerInstance;
    }

    private TimerInstance registerTimer(TimerInstance timerInstance) {
        ProcessInstanceJobDescription description = ProcessInstanceJobDescription.builder().id(timerInstance.getId()).timerId(timerInstance.getTimerId()).expirationTime((ExpirationTime)DurationExpirationTime.after((long)timerInstance.getDelay())).processInstanceId(this.getStringId()).processId(this.getProcessId()).build();
        JobsService jobsService = InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getJobsService();
        jobsService.scheduleProcessInstanceJob(description);
        return timerInstance;
    }

    private void registerExternalEventNodeListeners() {
        for (Node node : this.getWorkflowProcess().getNodes()) {
            if (node instanceof EventNode && "external".equals(((EventNode)node).getScope())) {
                this.addEventListener(((EventNode)node).getType(), DummyEventListener.EMPTY_EVENT_LISTENER, true);
                continue;
            }
            if (!(node instanceof EventSubProcessNode)) continue;
            List<String> events = ((EventSubProcessNode)node).getEvents();
            for (String type : events) {
                this.addEventListener(type, DummyEventListener.EMPTY_EVENT_LISTENER, true);
                if (!this.isVariableExpression(type)) continue;
                this.addEventListener(this.resolveVariable(type).toString(), DummyEventListener.EMPTY_EVENT_LISTENER, true);
            }
        }
        if (this.getWorkflowProcess().getMetaData().containsKey("Compensation")) {
            this.addEventListener("Compensation", new CompensationEventListener(this), true);
        }
    }

    private void unregisterExternalEventNodeListeners() {
        for (Node node : this.getWorkflowProcess().getNodes()) {
            if (!(node instanceof EventNode) || !"external".equals(((EventNode)node).getScope())) continue;
            this.externalEventListeners.remove(((EventNode)node).getType());
        }
    }

    private void handleSLAViolation() {
        if (this.slaCompliance == 1) {
            InternalKnowledgeRuntime kruntime = this.getKnowledgeRuntime();
            InternalProcessRuntime processRuntime = (InternalProcessRuntime)kruntime.getProcessRuntime();
            processRuntime.getProcessEventSupport().fireBeforeSLAViolated((KogitoProcessInstance)this, (KieRuntime)kruntime);
            logger.debug("SLA violated on process instance {}", (Object)this.getStringId());
            this.slaCompliance = 3;
            this.slaTimerId = null;
            processRuntime.getProcessEventSupport().fireAfterSLAViolated((KogitoProcessInstance)this, (KieRuntime)kruntime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalEvent(String type, Object event) {
        logger.debug("Signal {} received with data {} in process instance {}", new Object[]{type, event, this.getStringId()});
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = this;
        synchronized (workflowProcessInstanceImpl) {
            if (this.getState() != 1) {
                return;
            }
            if ("timerTriggered".equals(type)) {
                TimerInstance timer = (TimerInstance)event;
                if (timer.getId().equals(this.slaTimerId)) {
                    this.handleSLAViolation();
                    return;
                }
                if (timer.getId().equals(this.cancelTimerId)) {
                    logger.debug("Cancelling process instance id  {} because timer {} expires ", (Object)this.getStringId(), (Object)this.cancelTimerId);
                    this.cancelTimerId = null;
                    this.setState(3);
                    return;
                }
            }
            if ("slaViolation".equals(type)) {
                this.handleSLAViolation();
                return;
            }
            ArrayList<NodeInstance> currentView = new ArrayList<NodeInstance>(this.nodeInstances);
            try {
                this.activatingNodeIds = new ArrayList<String>();
                List<KogitoEventListener> listeners = this.eventListeners.get(type);
                if (listeners != null) {
                    for (KogitoEventListener listener : listeners) {
                        listener.signalEvent(type, event);
                    }
                }
                if ((listeners = this.externalEventListeners.get(type)) != null) {
                    for (KogitoEventListener listener : listeners) {
                        listener.signalEvent(type, event);
                    }
                }
                for (Node node : this.getWorkflowProcess().getNodes()) {
                    ExtendedNodeInstanceImpl eventNodeInstance;
                    if (!(node instanceof EventNodeInterface) || !((EventNodeInterface)node).acceptsEvent(type, event, this.getResolver(node, currentView))) continue;
                    if (node instanceof EventNode && ((EventNode)node).getFrom() == null) {
                        eventNodeInstance = (EventNodeInstance)this.getNodeInstance(node);
                        ((EventNodeInstance)eventNodeInstance).signalEvent(type, event, this.getResolver(node, currentView));
                        continue;
                    }
                    if (node instanceof EventSubProcessNode && this.resolveVariables(((EventSubProcessNode)node).getEvents()).contains(type)) {
                        eventNodeInstance = (EventSubProcessNodeInstance)this.getNodeInstance(node);
                        ((CompositeNodeInstance)eventNodeInstance).signalEvent(type, event);
                        continue;
                    }
                    List<NodeInstance> nodeInstances = this.getNodeInstances(node.getId(), currentView);
                    if (nodeInstances == null || nodeInstances.isEmpty()) continue;
                    for (NodeInstance nodeInstance : nodeInstances) {
                        ((EventNodeInstanceInterface)((Object)nodeInstance)).signalEvent(type, event, this.getResolver(node, currentView));
                    }
                }
                if (((WorkflowProcess)this.getWorkflowProcess()).isDynamic()) {
                    for (Node node : this.getWorkflowProcess().getNodes()) {
                        if (type.equals(node.getName()) && node.getIncomingConnections().isEmpty()) {
                            NodeInstance nodeInstance = this.getNodeInstance(node);
                            if (event != null) {
                                HashMap<String, Object> dynamicParams = new HashMap<String, Object>(this.getVariables());
                                if (event instanceof Map) {
                                    dynamicParams.putAll((Map)event);
                                } else {
                                    dynamicParams.put("Data", event);
                                }
                                nodeInstance.setDynamicParameters(dynamicParams);
                            }
                            nodeInstance.trigger(null, "DROOLS_DEFAULT");
                            continue;
                        }
                        if (!(node instanceof CompositeNode)) continue;
                        Optional<NodeInstance> instance = this.nodeInstances.stream().filter(ni -> ni.getNodeId().equals((Object)node.getId())).findFirst();
                        instance.ifPresent(n -> ((CompositeNodeInstance)n).signalEvent(type, event));
                    }
                }
            }
            finally {
                if (this.activatingNodeIds != null) {
                    this.activatingNodeIds.clear();
                    this.activatingNodeIds = null;
                }
            }
        }
    }

    private Function<String, Object> getResolver(Node node, List<NodeInstance> currentView) {
        if (node instanceof DynamicNode) {
            return e -> {
                List<NodeInstance> nodeInstances = this.getNodeInstances(node.getId(), currentView);
                if (nodeInstances != null && !nodeInstances.isEmpty()) {
                    StringBuilder st = new StringBuilder();
                    for (NodeInstance ni : nodeInstances) {
                        Object result = this.resolveVariable((String)e, (VariableResolverFactory)new NodeInstanceResolverFactory(ni));
                        st.append(result).append("###");
                    }
                    return st.toString();
                }
                return this.resolveVariable((String)e);
            };
        }
        return this::resolveVariable;
    }

    protected List<String> resolveVariables(List<String> events) {
        return events.stream().map(this::resolveVariable).map(Object::toString).collect(Collectors.toList());
    }

    private Object resolveVariable(String s) {
        return this.resolveVariable(s, (VariableResolverFactory)new ProcessInstanceResolverFactory((org.kie.api.runtime.process.WorkflowProcessInstance)this));
    }

    private Object resolveVariable(String s, VariableResolverFactory factory) {
        VariableScope var = (VariableScope)((ContextResolver)this.getProcess()).resolveContext("VariableScope", s);
        if (var != null) {
            return this.getVariable(s);
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            if (replacements.get(paramName) != null) continue;
            Object variableValue = this.getVariable(paramName);
            if (variableValue != null) {
                replacements.put(paramName, variableValue.toString());
                continue;
            }
            try {
                MVELEvaluator mvelEvaluator = MVELProcessHelper.evaluator();
                variableValue = mvelEvaluator.eval(paramName, factory);
                String variableValueString = variableValue == null ? "" : variableValue.toString();
                replacements.put(paramName, variableValueString);
            }
            catch (Exception t) {
                logger.error("Could not find variable scope for variable {}", (Object)paramName);
            }
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
        }
        return s;
    }

    @Override
    public void addEventListener(String type, KogitoEventListener listener, boolean external) {
        Map<String, List<KogitoEventListener>> eventListeners = external ? this.externalEventListeners : this.eventListeners;
        List listeners = eventListeners.computeIfAbsent(type, listenerType -> {
            CopyOnWriteArrayList newListenersList = new CopyOnWriteArrayList();
            if (external) {
                ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getSignalManager().addEventListener(listenerType, (EventListener)this);
            }
            return newListenersList;
        });
        listeners.add(listener);
    }

    @Override
    public void removeEventListener(String type, KogitoEventListener listener, boolean external) {
        Map<String, List<KogitoEventListener>> eventListeners = external ? this.externalEventListeners : this.eventListeners;
        List<KogitoEventListener> listeners = eventListeners.get(type);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                eventListeners.remove(type);
                if (external) {
                    ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getSignalManager().removeEventListener(type, (EventListener)this);
                }
            }
        } else {
            eventListeners.remove(type);
        }
    }

    private void removeEventListeners() {
        for (String type : this.externalEventListeners.keySet()) {
            ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getSignalManager().removeEventListener(type, (EventListener)this);
        }
    }

    @Override
    public String[] getEventTypes() {
        return this.externalEventListeners.keySet().stream().map(this::resolveVariable).collect(Collectors.toList()).toArray(new String[this.externalEventListeners.size()]);
    }

    public Set<EventDescription<?>> getEventDescriptions() {
        if (this.getState() == 2 || this.getState() == 3) {
            return Collections.emptySet();
        }
        VariableScope variableScope = (VariableScope)((ContextContainer)this.getProcess()).getDefaultContext("VariableScope");
        LinkedHashSet eventDesciptions = new LinkedHashSet();
        List<KogitoEventListener> activeListeners = this.eventListeners.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        activeListeners.addAll(this.externalEventListeners.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        activeListeners.forEach(el -> eventDesciptions.addAll(el.getEventDescriptions()));
        ((WorkflowProcess)this.getProcess()).getNodesRecursively().stream().filter(n -> n instanceof EventNodeInterface).forEach(n -> {
            Variable eventVar;
            NamedDataType dataType = null;
            if (((EventNodeInterface)n).getVariableName() != null && (eventVar = variableScope.findVariable(((EventNodeInterface)n).getVariableName())) != null) {
                dataType = new NamedDataType(eventVar.getName(), (Object)eventVar.getType());
            }
            if (n instanceof BoundaryEventNode) {
                BoundaryEventNode boundaryEventNode = (BoundaryEventNode)n;
                StateBasedNodeInstance attachedToNodeInstance = this.getNodeInstances(true).stream().filter(ni -> ni.getNode().getUniqueId().equals(boundaryEventNode.getAttachedToNodeId())).findFirst().orElse(null);
                if (attachedToNodeInstance != null) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("AttachedToID", attachedToNodeInstance.getNodeDefinitionId());
                    properties.put("AttachedToName", attachedToNodeInstance.getNodeName());
                    String eventType = "signal";
                    String eventName = boundaryEventNode.getType();
                    Map<String, String> timerProperties = attachedToNodeInstance.extractTimerEventInformation();
                    if (timerProperties != null) {
                        properties.putAll(timerProperties);
                        eventType = "timer";
                        eventName = "timerTriggered";
                    }
                    eventDesciptions.add((EventDescription<?>)new BaseEventDescription(eventName, n.getUniqueId(), n.getName(), eventType, null, this.getStringId(), dataType, properties));
                }
            } else if (n instanceof EventSubProcessNode) {
                EventSubProcessNode eventSubProcessNode = (EventSubProcessNode)n;
                StartNode startNode = eventSubProcessNode.findStartNode();
                Map<Timer, DroolsAction> timers = eventSubProcessNode.getTimers();
                if (timers != null && !timers.isEmpty()) {
                    this.getNodeInstances(eventSubProcessNode.getId()).forEach(arg_0 -> this.lambda$getEventDescriptions$8(eventDesciptions, (Node)startNode, arg_0));
                } else {
                    for (String eventName : eventSubProcessNode.getEvents()) {
                        eventDesciptions.add((EventDescription<?>)new BaseEventDescription(eventName, startNode.getUniqueId(), startNode.getName(), "signal", null, this.getStringId(), dataType));
                    }
                }
            } else if (n instanceof EventNode) {
                NamedDataType finalDataType = dataType;
                this.getNodeInstances(n.getId()).forEach(ni -> eventDesciptions.add((EventDescription<?>)new BaseEventDescription(((EventNode)n).getType(), n.getUniqueId(), n.getName(), n.getMetaData().getOrDefault("EventType", "signal"), ni.getStringId(), this.getStringId(), finalDataType)));
            } else if (n instanceof StateNode) {
                this.getNodeInstances(n.getId()).forEach(ni -> eventDesciptions.add((EventDescription<?>)new BaseEventDescription((String)n.getMetaData().get("Condition"), n.getUniqueId(), n.getName(), n.getMetaData().getOrDefault("EventType", "signal"), ni.getStringId(), this.getStringId(), null)));
            }
        });
        return eventDesciptions;
    }

    @Override
    public void nodeInstanceCompleted(NodeInstance nodeInstance, String outType) {
        Node nodeInstanceNode = nodeInstance.getNode();
        if (nodeInstanceNode != null) {
            boolean isForCompensation;
            Object compensationBoolObj = nodeInstanceNode.getMetaData().get("isForCompensation");
            boolean bl = isForCompensation = compensationBoolObj != null && (Boolean)compensationBoolObj != false;
            if (isForCompensation) {
                return;
            }
        }
        if (nodeInstance instanceof FaultNodeInstance || nodeInstance instanceof EndNodeInstance || ((WorkflowProcess)this.getWorkflowProcess()).isDynamic() || nodeInstance instanceof CompositeNodeInstance) {
            if (((WorkflowProcess)this.getProcess()).isAutoComplete() && this.canComplete()) {
                this.setState(2);
            }
        } else {
            throw new IllegalArgumentException("Completing a node instance that has no outgoing connection is not supported.");
        }
    }

    private boolean canComplete() {
        if (this.nodeInstances.isEmpty()) {
            return true;
        }
        int eventSubprocessCounter = 0;
        for (NodeInstance nodeInstance : this.nodeInstances) {
            Node node = nodeInstance.getNode();
            if (node instanceof EventSubProcessNode) {
                if (!((EventSubProcessNodeInstance)nodeInstance).getNodeInstances().isEmpty()) continue;
                ++eventSubprocessCounter;
                continue;
            }
            return false;
        }
        return eventSubprocessCounter == this.nodeInstances.size();
    }

    public void addCompletedNodeId(String uniqueId) {
        this.completedNodeIds.add(uniqueId.intern());
    }

    public List<String> getCompletedNodeIds() {
        return new ArrayList<String>(this.completedNodeIds);
    }

    @Override
    public int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
    }

    @Override
    public Map<String, Integer> getIterationLevels() {
        return this.iterationLevels;
    }

    public void addActivatingNodeId(String uniqueId) {
        if (this.activatingNodeIds == null) {
            return;
        }
        this.activatingNodeIds.add(uniqueId.intern());
    }

    public List<String> getActivatingNodeIds() {
        if (this.activatingNodeIds == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.activatingNodeIds);
    }

    @Override
    public Object getFaultData() {
        return this.faultData;
    }

    @Override
    public boolean isSignalCompletion() {
        return this.signalCompletion;
    }

    @Override
    public void setSignalCompletion(boolean signalCompletion) {
        this.signalCompletion = signalCompletion;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getCorrelationKey() {
        if (this.correlationKey == null && this.getMetaData().get("CorrelationKey") != null) {
            this.correlationKey = ((CorrelationKey)this.getMetaData().get("CorrelationKey")).toExternalForm();
        }
        return this.correlationKey;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        if (this.startDate == null) {
            this.startDate = startDate;
        }
    }

    protected boolean hasDeploymentId() {
        return this.deploymentId != null && !this.deploymentId.isEmpty();
    }

    protected boolean useTimerSLATracking() {
        String mode = (String)this.getKnowledgeRuntime().getEnvironment().get("SLATimerMode");
        if (mode == null) {
            return true;
        }
        return Boolean.parseBoolean(mode);
    }

    @Override
    public int getSlaCompliance() {
        return this.slaCompliance;
    }

    public void internalSetSlaCompliance(int slaCompliance) {
        this.slaCompliance = slaCompliance;
    }

    public Date getSlaDueDate() {
        return this.slaDueDate;
    }

    public void internalSetSlaDueDate(Date slaDueDate) {
        this.slaDueDate = slaDueDate;
    }

    public String getSlaTimerId() {
        return this.slaTimerId;
    }

    public void internalSetSlaTimerId(String slaTimerId) {
        this.slaTimerId = slaTimerId;
    }

    public String getCancelTimerId() {
        return this.cancelTimerId;
    }

    public void internalSetCancelTimerId(String cancelTimerId) {
        this.cancelTimerId = cancelTimerId;
    }

    public String getNodeIdInError() {
        return this.nodeIdInError;
    }

    public String getNodeInstanceIdInError() {
        return this.nodeInstanceIdInError;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Optional<Throwable> getErrorCause() {
        return this.errorCause;
    }

    @Override
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    private boolean isVariableExpression(String eventType) {
        if (eventType == null) {
            return false;
        }
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(eventType);
        return matcher.find();
    }

    @Override
    public void setErrorState(NodeInstance nodeInstanceInError, Exception e) {
        this.nodeIdInError = nodeInstanceInError.getNodeDefinitionId();
        this.nodeInstanceIdInError = nodeInstanceInError.getId();
        this.errorCause = Optional.of(e);
        Throwable rootException = this.getRootException(e);
        this.errorMessage = rootException.getClass().getCanonicalName() + " - " + rootException.getMessage();
        this.setState(5);
        logger.error("Unexpected error while executing node {} in process instance {}", new Object[]{nodeInstanceInError.getNode().getName(), this.getStringId(), e});
        ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getProcessEventSupport().fireOnError((KogitoProcessInstance)this, (KogitoNodeInstance)nodeInstanceInError, (KieRuntime)this.getKnowledgeRuntime(), e);
        ((NodeInstanceContainer)nodeInstanceInError.getNodeInstanceContainer()).removeNodeInstance(nodeInstanceInError);
    }

    public void internalSetErrorNodeId(String errorNodeId) {
        this.nodeIdInError = errorNodeId;
    }

    public void internalSetErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.errorCause = Optional.empty();
    }

    public Collection<AdHocFragment> adHocFragments() {
        return Stream.of(this.getNodeContainer().getNodes()).filter(n -> !(n instanceof StartNode) && !(n instanceof BoundaryEventNode)).filter(n -> n.getIncomingConnections().isEmpty()).map(node -> new AdHocFragment.Builder(node.getClass()).withName(node.getName()).withAutoStart(Boolean.parseBoolean((String)node.getMetaData().get("customAutoStart"))).build()).collect(Collectors.toSet());
    }

    public Collection<Milestone> milestones() {
        return this.getNodesByType(MilestoneNode.class).map(n -> {
            String uid = n.getUniqueId();
            return Milestone.builder().withId(uid).withName(n.getName()).withStatus(this.getMilestoneStatus(uid)).build();
        }).collect(Collectors.toSet());
    }

    private <N extends Node> Stream<N> getNodesByType(Class<N> nodeClass) {
        return this.getWorkflowProcess().getNodesRecursively().stream().filter(nodeClass::isInstance).map(nodeClass::cast);
    }

    private ItemDescription.Status getMilestoneStatus(String uid) {
        if (this.getCompletedNodeIds().contains(uid)) {
            return ItemDescription.Status.COMPLETED;
        }
        if (this.getActiveNodeIds().contains(uid)) {
            return ItemDescription.Status.ACTIVE;
        }
        return ItemDescription.Status.AVAILABLE;
    }

    protected Throwable getRootException(Throwable exception) {
        Throwable rootException = exception;
        while (rootException.getCause() != null) {
            rootException = rootException.getCause();
        }
        return rootException;
    }

    @Override
    public AgendaFilter getAgendaFilter() {
        return this.agendaFilter;
    }

    @Override
    public void setAgendaFilter(AgendaFilter agendaFilter) {
        this.agendaFilter = agendaFilter;
    }

    public final void wrap(ProcessInstance<?> kogitoProcessInstance) {
        this.kogitoProcessInstance = kogitoProcessInstance;
    }

    public final ProcessInstance<?> unwrap() {
        return this.kogitoProcessInstance;
    }

    private /* synthetic */ void lambda$getEventDescriptions$8(Set eventDesciptions, Node startNode, NodeInstance ni) {
        Map<String, String> timerProperties = ((StateBasedNodeInstance)ni).extractTimerEventInformation();
        if (timerProperties != null) {
            eventDesciptions.add(new BaseEventDescription("timerTriggered", startNode.getUniqueId(), startNode.getName(), "timer", ni.getStringId(), this.getStringId(), null, timerProperties));
        }
    }
}

