/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jbpm.process.core.Work;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.process.instance.impl.humantask.DeadlineHelper;
import org.jbpm.process.instance.impl.humantask.DeadlineInfo;
import org.jbpm.process.instance.impl.humantask.HumanTaskHelper;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemImpl;
import org.jbpm.process.instance.impl.humantask.InternalHumanTaskWorkItem;
import org.jbpm.process.instance.impl.humantask.Reassignment;
import org.jbpm.process.instance.impl.humantask.ScheduleInfo;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.process.workitem.HumanTaskWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.timer.TimerInstance;

public class HumanTaskNodeInstance
extends WorkItemNodeInstance {
    private static final long serialVersionUID = 510L;
    private static final String NODE_NAME = "NodeName";
    private static final String DESCRIPTION = "Description";
    private static final String PRIORITY = "Priority";
    private static final String TASK_NAME = "TaskName";
    private String separator = System.getProperty("org.jbpm.ht.user.separator", ",");
    private static final String ACTOR_ID = "ActorId";
    private static final String GROUP_ID = "GroupId";
    private static final String BUSINESSADMINISTRATOR_ID = "BusinessAdministratorId";
    private static final String BUSINESSADMINISTRATOR_GROUP_ID = "BusinessAdministratorGroupId";
    private static final String EXCLUDED_OWNER_ID = "ExcludedOwnerId";
    private static final String WORK_ITEM_TRANSITION = "workItemTransition";
    private transient SwimlaneContextInstance swimlaneContextInstance;
    private Map<String, Map<String, Object>> notStartedDeadlines = new ConcurrentHashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> notCompletedDeadlines = new ConcurrentHashMap<String, Map<String, Object>>();
    private Map<String, Reassignment> notStartedReassignments = new ConcurrentHashMap<String, Reassignment>();
    private Map<String, Reassignment> notCompletedReassignments = new ConcurrentHashMap<String, Reassignment>();

    public HumanTaskNode getHumanTaskNode() {
        return (HumanTaskNode)this.getNode();
    }

    @Override
    public InternalHumanTaskWorkItem getWorkItem() {
        return (InternalHumanTaskWorkItem)super.getWorkItem();
    }

    @Override
    protected InternalKogitoWorkItem decorate(InternalKogitoWorkItem kogitoWorkItem) {
        this.getKogitoProcessInstance();
        return HumanTaskHelper.decorate(this, (InternalHumanTaskWorkItem)kogitoWorkItem);
    }

    @Override
    protected InternalKogitoWorkItem newWorkItem() {
        return HumanTaskHelper.decorate(this, new HumanTaskWorkItemImpl());
    }

    public Map<String, Map<String, Object>> getNotStartedDeadlineTimers() {
        return this.notStartedDeadlines;
    }

    public Map<String, Map<String, Object>> getNotCompletedDeadlineTimers() {
        return this.notCompletedDeadlines;
    }

    public Map<String, Reassignment> getNotStartedReassignments() {
        return this.notStartedReassignments;
    }

    public Map<String, Reassignment> getNotCompletedReassigments() {
        return this.notCompletedReassignments;
    }

    @Override
    protected InternalKogitoWorkItem createWorkItem(WorkItemNode workItemNode) {
        InternalHumanTaskWorkItem workItem = (InternalHumanTaskWorkItem)super.createWorkItem(workItemNode);
        String actorId = this.assignWorkItem(workItem);
        if (actorId != null) {
            workItem.setParameter(ACTOR_ID, actorId);
        }
        workItem.setTaskName((String)workItem.getParameter(TASK_NAME));
        workItem.setTaskDescription((String)workItem.getParameter(DESCRIPTION));
        workItem.setTaskPriority((String)workItem.getParameter(PRIORITY));
        workItem.setReferenceName((String)workItem.getParameter(NODE_NAME));
        Work work = workItemNode.getWork();
        this.scheduleDeadlines(work.getNotStartedDeadlines(), this.notStartedDeadlines);
        this.scheduleDeadlines(work.getNotCompletedDeadlines(), this.notCompletedDeadlines);
        this.scheduleDeadlines(work.getNotStartedReassignments(), this.notStartedReassignments);
        this.scheduleDeadlines(work.getNotCompletedReassigments(), this.notCompletedReassignments);
        return workItem;
    }

    private <T> void scheduleDeadlines(Collection<DeadlineInfo<T>> deadlines, Map<String, T> timers) {
        if (!deadlines.isEmpty()) {
            WorkflowProcessInstance pi = this.getProcessInstance();
            for (DeadlineInfo<T> deadline : deadlines) {
                for (ScheduleInfo info : deadline.getScheduleInfo()) {
                    timers.put(this.getJobsService().scheduleProcessInstanceJob(ProcessInstanceJobDescription.builder().generateId().timerId("-1").expirationTime(DeadlineHelper.getExpirationTime(info)).processInstanceId(pi.getStringId()).rootProcessInstanceId(pi.getRootProcessInstanceId()).processId(pi.getProcessId()).rootProcessId(pi.getRootProcessId()).nodeInstanceId(this.getStringId()).build()), deadline.getNotification());
                }
            }
        }
    }

    @Override
    public void signalEvent(String type, Object event) {
        switch (type) {
            case "workItemTransition": {
                this.cancelTimers(this.notStartedDeadlines);
                this.cancelTimers(this.notStartedReassignments);
                break;
            }
            case "timerTriggered": {
                if (this.sendNotification((TimerInstance)event)) break;
                super.signalEvent(type, event);
                break;
            }
            default: {
                super.signalEvent(type, event);
            }
        }
    }

    private boolean sendNotification(TimerInstance timerInstance) {
        boolean processed = this.checkAndSendNotitication(this.notStartedDeadlines, timerInstance, this::startNotification);
        if (!processed) {
            processed = this.checkAndSendNotitication(this.notCompletedDeadlines, timerInstance, this::endNotification);
        }
        if (!processed) {
            processed = this.checkAndReassign(this.notStartedReassignments, timerInstance);
        }
        if (!processed) {
            processed = this.checkAndReassign(this.notCompletedReassignments, timerInstance);
        }
        return processed;
    }

    private boolean checkAndSendNotitication(Map<String, Map<String, Object>> timers, TimerInstance timerInstance, Consumer<Map<String, Object>> publisher) {
        boolean result;
        Map<String, Object> notification = timers.get(timerInstance.getId());
        boolean bl = result = notification != null;
        if (result) {
            if (timerInstance.getRepeatLimit() <= 0) {
                timers.remove(timerInstance.getId());
            }
            publisher.accept(notification);
        }
        return result;
    }

    private boolean checkAndReassign(Map<String, Reassignment> timers, TimerInstance timerInstance) {
        boolean result;
        Reassignment reassignment = timers.remove(timerInstance.getId());
        boolean bl = result = reassignment != null;
        if (result) {
            this.reassign(reassignment);
        }
        return result;
    }

    @Override
    protected void addWorkItemListener() {
        super.addWorkItemListener();
        this.getProcessInstance().addEventListener(WORK_ITEM_TRANSITION, this, false);
    }

    @Override
    protected void removeWorkItemListener() {
        super.removeWorkItemListener();
        this.getProcessInstance().removeEventListener(WORK_ITEM_TRANSITION, this, false);
    }

    private KogitoProcessEventSupport getEventSupport() {
        return InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getProcessEventSupport();
    }

    private JobsService getJobsService() {
        return InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getJobsService();
    }

    private void startNotification(Map<String, Object> notification) {
        this.getEventSupport().fireOnUserTaskNotStartedDeadline((KogitoProcessInstance)this.getProcessInstance(), (KogitoNodeInstance)this, (HumanTaskWorkItem)this.getWorkItem(), notification, (KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
    }

    private void endNotification(Map<String, Object> notification) {
        this.getEventSupport().fireOnUserTaskNotCompletedDeadline((KogitoProcessInstance)this.getProcessInstance(), (KogitoNodeInstance)this, (HumanTaskWorkItem)this.getWorkItem(), notification, (KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
    }

    private void reassign(Reassignment reassignment) {
        InternalHumanTaskWorkItem humanTask = HumanTaskHelper.asHumanTask((KogitoWorkItem)this.getWorkItem());
        boolean modified = false;
        if (!reassignment.getPotentialUsers().isEmpty()) {
            humanTask.setPotentialUsers(reassignment.getPotentialUsers());
            modified = true;
        }
        if (!reassignment.getPotentialGroups().isEmpty()) {
            humanTask.setPotentialGroups(reassignment.getPotentialGroups());
            modified = true;
        }
        if (modified) {
            this.getEventSupport().fireAfterWorkItemTransition((KogitoProcessInstance)this.getProcessInstance(), (KogitoWorkItem)humanTask, null, null);
        }
    }

    protected String assignWorkItem(InternalKogitoWorkItem workItem) {
        String actorId = null;
        String swimlaneName = this.getHumanTaskNode().getSwimlane();
        SwimlaneContextInstance swimlaneContextInstance = this.getSwimlaneContextInstance(swimlaneName);
        if (swimlaneContextInstance != null) {
            actorId = swimlaneContextInstance.getActorId(swimlaneName);
            workItem.setParameter("SwimlaneActorId", (Object)actorId);
        }
        if (actorId == null && (actorId = (String)workItem.getParameter(ACTOR_ID)) != null && swimlaneContextInstance != null && actorId.split(this.separator).length == 1) {
            swimlaneContextInstance.setActorId(swimlaneName, actorId);
            workItem.setParameter("SwimlaneActorId", (Object)actorId);
        }
        InternalHumanTaskWorkItem hunanWorkItem = (InternalHumanTaskWorkItem)workItem;
        HashSet<String> newPUValue = new HashSet<String>(hunanWorkItem.getPotentialUsers());
        this.processAssigment(ACTOR_ID, workItem, newPUValue);
        hunanWorkItem.setPotentialUsers(newPUValue);
        HashSet<String> newPGValue = new HashSet<String>(hunanWorkItem.getPotentialGroups());
        this.processAssigment(GROUP_ID, workItem, newPGValue);
        hunanWorkItem.setPotentialGroups(newPGValue);
        HashSet<String> newEUValue = new HashSet<String>(hunanWorkItem.getExcludedUsers());
        this.processAssigment(EXCLUDED_OWNER_ID, workItem, newEUValue);
        hunanWorkItem.setExcludedUsers(newEUValue);
        HashSet<String> newAUValue = new HashSet<String>(hunanWorkItem.getAdminUsers());
        this.processAssigment(BUSINESSADMINISTRATOR_ID, workItem, newAUValue);
        hunanWorkItem.setAdminGroups(newAUValue);
        HashSet<String> newAGValue = new HashSet<String>(hunanWorkItem.getAdminGroups());
        this.processAssigment(BUSINESSADMINISTRATOR_GROUP_ID, workItem, newAGValue);
        hunanWorkItem.setAdminGroups(newAGValue);
        return (String)workItem.getParameter(ACTOR_ID);
    }

    private SwimlaneContextInstance getSwimlaneContextInstance(String swimlaneName) {
        if (this.swimlaneContextInstance == null) {
            if (swimlaneName == null) {
                return null;
            }
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)this.resolveContextInstance("SwimlaneScope", swimlaneName);
            if (swimlaneContextInstance == null) {
                throw new IllegalArgumentException("Could not find swimlane context instance");
            }
            this.swimlaneContextInstance = swimlaneContextInstance;
        }
        return this.swimlaneContextInstance;
    }

    @Override
    public void triggerCompleted(InternalKogitoWorkItem workItem) {
        this.cancelTimers(this.notStartedDeadlines);
        this.cancelTimers(this.notCompletedDeadlines);
        this.cancelTimers(this.notStartedReassignments);
        this.cancelTimers(this.notCompletedReassignments);
        String swimlaneName = this.getHumanTaskNode().getSwimlane();
        SwimlaneContextInstance swimlaneContextInstance = this.getSwimlaneContextInstance(swimlaneName);
        if (swimlaneContextInstance != null) {
            String newActorId;
            String string = newActorId = workItem instanceof HumanTaskWorkItem ? ((HumanTaskWorkItem)workItem).getActualOwner() : (String)workItem.getParameter(ACTOR_ID);
            if (newActorId != null) {
                swimlaneContextInstance.setActorId(swimlaneName, newActorId);
            }
        }
        super.triggerCompleted(workItem);
    }

    private <T> void cancelTimers(Map<String, T> timers) {
        Iterator<String> iter = timers.keySet().iterator();
        while (iter.hasNext()) {
            this.getJobsService().cancelJob(iter.next());
            iter.remove();
        }
    }

    protected void processAssigment(String type, InternalKogitoWorkItem workItem, Set<String> store) {
        String value = (String)workItem.getParameter(type);
        if (value != null) {
            for (String item : value.split(this.separator)) {
                store.add(item);
            }
        }
    }
}

