/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.context.exception;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.AbstractContext;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionHandlerPolicy;
import org.jbpm.process.core.context.exception.ExceptionHandlerPolicyFactory;
import org.kie.kogito.internal.process.workitem.WorkItemExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionScope
extends AbstractContext {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(ExceptionScope.class);
    public static final String EXCEPTION_SCOPE = "ExceptionScope";
    protected Map<String, ExceptionHandler> exceptionHandlers = new HashMap<String, ExceptionHandler>();
    private transient Collection<ExceptionHandlerPolicy> policies = ExceptionHandlerPolicyFactory.getHandlerPolicies();

    @Override
    public String getType() {
        return EXCEPTION_SCOPE;
    }

    public void setExceptionHandler(String exception, ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.put(exception, exceptionHandler);
    }

    public ExceptionHandler getExceptionHandler(String exception) {
        ExceptionHandler result = this.exceptionHandlers.get(exception);
        if (result == null) {
            result = this.exceptionHandlers.get(null);
        }
        return result;
    }

    protected ExceptionHandler getHandlerFromPolicies(Throwable exception) {
        for (ExceptionHandlerPolicy policy : this.policies) {
            for (Map.Entry<String, ExceptionHandler> handler : this.exceptionHandlers.entrySet()) {
                String className = handler.getKey();
                if (className == null || !policy.test(className, exception)) continue;
                logger.debug("Policy {} matches handler {}", (Object)policy.getClass().getSimpleName(), (Object)handler.getKey());
                return handler.getValue();
            }
        }
        return null;
    }

    public ExceptionHandler getExceptionHandler(Throwable exception) {
        ExceptionHandler handler = this.getHandlerFromPolicies(exception);
        if (handler == null && exception instanceof WorkItemExecutionException) {
            handler = this.exceptionHandlers.get(((WorkItemExecutionException)exception).getErrorCode());
        }
        if (handler == null) {
            handler = this.exceptionHandlers.get(null);
        }
        return handler;
    }

    public void removeExceptionHandler(String exception) {
        this.exceptionHandlers.remove(exception);
    }

    public Map<String, ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public void setExceptionHandlers(Map<String, ExceptionHandler> exceptionHandlers) {
        if (exceptionHandlers == null) {
            throw new IllegalArgumentException("Exception handlers are null");
        }
        this.exceptionHandlers = exceptionHandlers;
    }

    @Override
    public Context resolveContext(Object param) {
        if (param instanceof String) {
            return this.getExceptionHandler((String)param) == null ? null : this;
        }
        if (param instanceof Throwable) {
            return this.getExceptionHandler((Throwable)param) == null ? null : this;
        }
        throw new IllegalArgumentException("ExceptionScopes can only resolve exception names: " + param);
    }
}

