/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;

public class ContextContainerImpl
implements Serializable,
ContextContainer {
    private static final long serialVersionUID = 510L;
    private Map<String, Context> defaultContexts = new HashMap<String, Context>();
    private Map<String, List<Context>> subContexts = new HashMap<String, List<Context>>();
    private long lastContextId;

    @Override
    public List<Context> getContexts(String contextType) {
        return this.subContexts.get(contextType);
    }

    @Override
    public void addContext(Context context) {
        List<Context> list = this.subContexts.get(context.getType());
        if (list == null) {
            list = new ArrayList<Context>();
            this.subContexts.put(context.getType(), list);
        }
        if (!list.contains(context)) {
            list.add(context);
            context.setId(++this.lastContextId);
        }
    }

    @Override
    public Context getContext(String contextType, long id) {
        List<Context> list = this.subContexts.get(contextType);
        if (list != null) {
            for (Context context : list) {
                if (context.getId() != id) continue;
                return context;
            }
        }
        return null;
    }

    @Override
    public void setDefaultContext(Context context) {
        this.defaultContexts.put(context.getType(), context);
    }

    @Override
    public Context getDefaultContext(String contextType) {
        return this.defaultContexts.get(contextType);
    }
}

