/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.jbpm.process.core.timer.CalendarBean;
import org.jbpm.process.core.timer.CalendarBeanFactory;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.util.PatternConstants;
import org.kie.kogito.calendar.BusinessCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessCalendarImpl
implements BusinessCalendar {
    private static final Logger logger = LoggerFactory.getLogger(BusinessCalendarImpl.class);
    private static final long HOUR_IN_MILLIS = 3600000L;
    private final int daysPerWeek;
    private final int hoursInDay;
    private final int startHour;
    private final int endHour;
    private final String timezone;
    private final List<TimePeriod> holidays;
    private final List<Integer> weekendDays;
    private final Calendar testingCalendar;
    private static final int SIM_WEEK = 3;
    private static final int SIM_DAY = 5;
    private static final int SIM_HOU = 7;
    private static final int SIM_MIN = 9;
    private static final int SIM_SEC = 11;
    public static final String START_HOUR = "business.start.hour";
    public static final String END_HOUR = "business.end.hour";
    public static final String HOLIDAYS = "business.holidays";
    public static final String HOLIDAY_DATE_FORMAT = "business.holiday.date.format";
    public static final String WEEKEND_DAYS = "business.weekend.days";
    public static final String TIMEZONE = "business.cal.timezone";

    public static Builder builder() {
        return new Builder();
    }

    private BusinessCalendarImpl(Calendar testingCalendar) {
        this(CalendarBeanFactory.createCalendarBean(), testingCalendar);
    }

    private BusinessCalendarImpl(CalendarBean calendarBean, Calendar testingCalendar) {
        this.holidays = calendarBean.getHolidays();
        this.weekendDays = calendarBean.getWeekendDays();
        this.daysPerWeek = calendarBean.getDaysPerWeek();
        this.timezone = calendarBean.getTimezone();
        this.startHour = calendarBean.getStartHour();
        this.endHour = calendarBean.getEndHour();
        this.hoursInDay = calendarBean.getHoursInDay();
        this.testingCalendar = testingCalendar;
        logger.debug("\tholidays: {},\n\tweekendDays: {},\n\tdaysPerWeek: {},\n\ttimezone: {},\n\tstartHour: {},\n\tendHour: {},\n\thoursInDay: {}", new Object[]{this.holidays, this.weekendDays, this.daysPerWeek, this.timezone, this.startHour, this.endHour, this.hoursInDay});
    }

    public long calculateBusinessTimeAsDuration(String timeExpression) {
        logger.trace("timeExpression {}", (Object)timeExpression);
        timeExpression = this.adoptISOFormat(timeExpression);
        Date calculatedDate = this.calculateBusinessTimeAsDate(timeExpression);
        logger.debug("calculatedDate: {}, currentTime: {}, timeExpression: {}, Difference: {} ms", new Object[]{calculatedDate, new Date(this.getCurrentTime()), timeExpression, calculatedDate.getTime() - this.getCurrentTime()});
        return calculatedDate.getTime() - this.getCurrentTime();
    }

    public Date calculateBusinessTimeAsDate(String timeExpression) {
        int currentCalHour;
        Matcher mat;
        logger.trace("timeExpression {}", (Object)timeExpression);
        timeExpression = this.adoptISOFormat(timeExpression);
        String trimmed = timeExpression.trim();
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int min = 0;
        int sec = 0;
        if (!trimmed.isEmpty() && (mat = PatternConstants.SIMPLE_TIME_DATE_MATCHER.matcher(trimmed)).matches()) {
            weeks = mat.group(3) != null ? Integer.parseInt(mat.group(3)) : 0;
            days = mat.group(5) != null ? Integer.parseInt(mat.group(5)) : 0;
            hours = mat.group(7) != null ? Integer.parseInt(mat.group(7)) : 0;
            min = mat.group(9) != null ? Integer.parseInt(mat.group(9)) : 0;
            sec = mat.group(11) != null ? Integer.parseInt(mat.group(11)) : 0;
        }
        logger.trace("weeks: {}", (Object)weeks);
        logger.trace("days: {}", (Object)days);
        logger.trace("hours: {}", (Object)hours);
        logger.trace("min: {}", (Object)min);
        logger.trace("sec: {}", (Object)sec);
        int time = 0;
        Calendar calendar = this.getCalendar();
        logger.trace("calendar selected for business calendar: {}", (Object)calendar.getTime());
        if (this.timezone != null) {
            calendar.setTimeZone(TimeZone.getTimeZone(this.timezone));
        }
        int numberOfWeeks = days / this.daysPerWeek + weeks;
        logger.trace("number of weeks: {}", (Object)numberOfWeeks);
        if (numberOfWeeks > 0) {
            calendar.add(3, numberOfWeeks);
        }
        logger.trace("calendar WEEK_OF_YEAR: {}", (Object)calendar.get(3));
        BusinessCalendarImpl.rollCalendarToNextWorkingDayIfCurrentDayIsNonWorking(calendar, this.weekendDays, hours > 0 || min > 0);
        int numberOfDays = (hours += (days - numberOfWeeks * this.daysPerWeek) * this.hoursInDay) / this.hoursInDay;
        logger.trace("numberOfDays: {}", (Object)numberOfDays);
        if (numberOfDays > 0) {
            for (int i = 0; i < numberOfDays; ++i) {
                calendar.add(6, 1);
                boolean resetTime = false;
                BusinessCalendarImpl.rollCalendarToNextWorkingDayIfCurrentDayIsNonWorking(calendar, this.weekendDays, resetTime);
                logger.trace("calendar after rolling to next working day: {} when number of days > 0", (Object)calendar.getTime());
                BusinessCalendarImpl.rollCalendarAfterHolidays(calendar, this.holidays, this.weekendDays, hours > 0 || min > 0);
                logger.trace("calendar after holidays when number of days > 0: {}", (Object)calendar.getTime());
            }
        }
        boolean resetMinuteSecond = (currentCalHour = calendar.get(11)) >= this.endHour || currentCalHour < this.startHour;
        this.rollCalendarToWorkingHour(calendar, resetMinuteSecond);
        logger.trace("calendar after rolling to working hour: {}", (Object)calendar.getTime());
        time = hours - numberOfDays * this.hoursInDay;
        calendar.add(10, time);
        logger.trace("calendar after adding time {}: {}", (Object)time, (Object)calendar.getTime());
        boolean resetTime = true;
        BusinessCalendarImpl.rollCalendarToNextWorkingDayIfCurrentDayIsNonWorking(calendar, this.weekendDays, resetTime);
        logger.trace("calendar after rolling to next working day: {}", (Object)calendar.getTime());
        BusinessCalendarImpl.rollCalendarAfterHolidays(calendar, this.holidays, this.weekendDays, hours > 0 || min > 0);
        logger.trace("calendar after holidays: {}", (Object)calendar.getTime());
        this.rollCalendarToWorkingHour(calendar, false);
        logger.trace("calendar after rolling to working hour: {}", (Object)calendar.getTime());
        int numberOfHours = min / 60;
        if (numberOfHours > 0) {
            calendar.add(10, numberOfHours);
            min -= numberOfHours * 60;
        }
        calendar.add(12, min);
        int numberOfMinutes = sec / 60;
        if (numberOfMinutes > 0) {
            calendar.add(12, numberOfMinutes);
            sec -= numberOfMinutes * 60;
        }
        calendar.add(13, sec);
        logger.trace("calendar after adding {} hour, {} minutes and {} seconds: {}", new Object[]{numberOfHours, numberOfMinutes, sec, calendar.getTime()});
        this.rollCalendarToWorkingHour(calendar, false);
        logger.trace("calendar after rolling to next working day: {}", (Object)calendar.getTime());
        resetTime = false;
        BusinessCalendarImpl.rollCalendarToNextWorkingDayIfCurrentDayIsNonWorking(calendar, this.weekendDays, resetTime);
        logger.trace("calendar after rolling to next working day: {}", (Object)calendar.getTime());
        BusinessCalendarImpl.rollCalendarAfterHolidays(calendar, this.holidays, this.weekendDays, resetTime);
        logger.trace("calendar after holidays: {}", (Object)calendar.getTime());
        return calendar.getTime();
    }

    protected Calendar getCalendar() {
        String debugMessage = this.testingCalendar != null ? "Returning clone of testingCalendar " : "Return new GregorianCalendar";
        logger.trace(debugMessage);
        return this.testingCalendar != null ? (Calendar)this.testingCalendar.clone() : new GregorianCalendar();
    }

    protected void rollCalendarToWorkingHour(Calendar toRoll, boolean resetMinuteSecond) {
        logger.trace("toRoll: {}", (Object)toRoll.getTime());
        if (this.startHour >= this.endHour) {
            throw new UnsupportedOperationException(String.format("This feature is not supported yet: %s should be greater than %s", END_HOUR, START_HOUR));
        }
        BusinessCalendarImpl.rollCalendarToDailyWorkingHour(toRoll, this.startHour, this.endHour);
        if (resetMinuteSecond) {
            toRoll.set(12, 0);
            toRoll.set(13, 0);
        }
    }

    static void rollCalendarToDailyWorkingHour(Calendar toRoll, int startHour, int endHour) {
        logger.trace("toRoll: {}", (Object)toRoll.getTime());
        logger.trace("startHour: {}", (Object)startHour);
        logger.trace("endHour: {}", (Object)endHour);
        int currentCalHour = toRoll.get(11);
        if (currentCalHour >= endHour) {
            toRoll.add(6, 1);
            toRoll.set(11, startHour);
        } else if (currentCalHour < startHour) {
            toRoll.add(11, startHour - currentCalHour);
        }
        logger.trace("calendar after rolling to daily working hour: {}", (Object)toRoll.getTime());
    }

    static void rollCalendarToNightlyWorkingHour(Calendar toRoll, int startHour, int endHour) {
        logger.trace("toRoll: {}", (Object)toRoll.getTime());
        logger.trace("startHour: {}", (Object)startHour);
        logger.trace("endHour: {}", (Object)endHour);
        int currentCalHour = toRoll.get(11);
        if (currentCalHour < endHour) {
            toRoll.set(11, endHour);
        } else if (currentCalHour >= startHour) {
            toRoll.add(6, 1);
            toRoll.set(11, endHour);
        }
        toRoll.set(12, 0);
        toRoll.set(13, 0);
        logger.debug("calendar after rolling to nightly working hour: {}", (Object)toRoll.getTime());
    }

    static void rollCalendarAfterHolidays(Calendar toRoll, List<TimePeriod> holidays, List<Integer> weekendDays, boolean resetTime) {
        logger.trace("toRoll: {}", (Object)toRoll.getTime());
        logger.trace("holidays: {}", holidays);
        logger.trace("weekendDays: {}", weekendDays);
        logger.trace("resetTime: {}", (Object)resetTime);
        if (!holidays.isEmpty()) {
            Date current = toRoll.getTime();
            for (TimePeriod holiday : holidays) {
                if (!current.after(holiday.getFrom()) || !current.before(holiday.getTo())) continue;
                GregorianCalendar lastHolidayDayTime = new GregorianCalendar();
                lastHolidayDayTime.setTime(holiday.getTo());
                GregorianCalendar currentDayTmp = new GregorianCalendar();
                currentDayTmp.setTime(current);
                currentDayTmp.set(11, 0);
                currentDayTmp.set(12, 0);
                currentDayTmp.set(13, 0);
                currentDayTmp.set(14, 0);
                long difference = lastHolidayDayTime.getTimeInMillis() - currentDayTmp.getTimeInMillis();
                int dayDifference = (int)Math.ceil((double)difference / 8.64E7);
                toRoll.add(5, dayDifference);
                BusinessCalendarImpl.rollCalendarToNextWorkingDayIfCurrentDayIsNonWorking(toRoll, weekendDays, resetTime);
                break;
            }
        }
    }

    static void rollCalendarToNextWorkingDayIfCurrentDayIsNonWorking(Calendar toRoll, List<Integer> weekendDays, boolean resetTime) {
        logger.trace("toRoll: {}", (Object)toRoll.getTime());
        logger.trace("weekendDays: {}", weekendDays);
        logger.trace("resetTime: {}", (Object)resetTime);
        int dayOfTheWeek = toRoll.get(7);
        logger.trace("dayOfTheWeek: {}", (Object)dayOfTheWeek);
        while (!BusinessCalendarImpl.isWorkingDay(weekendDays, dayOfTheWeek)) {
            toRoll.add(6, 1);
            if (resetTime) {
                toRoll.set(11, 0);
                toRoll.set(12, 0);
                toRoll.set(13, 0);
                toRoll.set(14, 0);
            }
            dayOfTheWeek = toRoll.get(7);
        }
        logger.trace("dayOfTheWeek after rolling calendar: {}", (Object)dayOfTheWeek);
    }

    static boolean isWorkingDay(List<Integer> weekendDays, int day) {
        logger.trace("weekendDays: {}", weekendDays);
        logger.trace("day: {}", (Object)day);
        return !weekendDays.contains(day);
    }

    protected long getCurrentTime() {
        String debugMessage = this.testingCalendar != null ? "Returning testingCalendar time " : "Return System time";
        return this.testingCalendar != null ? this.testingCalendar.getTimeInMillis() : System.currentTimeMillis();
    }

    protected String adoptISOFormat(String timeExpression) {
        logger.trace("timeExpression: {}", (Object)timeExpression);
        try {
            Duration p = null;
            if (DateTimeUtils.isPeriod(timeExpression)) {
                p = Duration.parse(timeExpression);
            } else if (DateTimeUtils.isNumeric(timeExpression)) {
                p = Duration.of(Long.valueOf(timeExpression), ChronoUnit.MILLIS);
            } else {
                OffsetDateTime dateTime = OffsetDateTime.parse(timeExpression, DateTimeFormatter.ISO_DATE_TIME);
                p = Duration.between(OffsetDateTime.now(), dateTime);
            }
            long days = p.toDays();
            long hours = p.toHours() % 24L;
            long minutes = p.toMinutes() % 60L;
            long seconds = p.getSeconds() % 60L;
            long milis = p.toMillis() % 1000L;
            StringBuffer time = new StringBuffer();
            if (days > 0L) {
                time.append(days + "d");
            }
            if (hours > 0L) {
                time.append(hours + "h");
            }
            if (minutes > 0L) {
                time.append(minutes + "m");
            }
            if (seconds > 0L) {
                time.append(seconds + "s");
            }
            if (milis > 0L) {
                time.append(milis + "ms");
            }
            return time.toString();
        }
        catch (Exception e) {
            return timeExpression;
        }
    }

    public static class Builder {
        private CalendarBean calendarBean;
        private Calendar testingCalendar;

        public Builder withCalendarBean(CalendarBean calendarBean) {
            this.calendarBean = calendarBean;
            return this;
        }

        public Builder withTestingCalendar(Calendar testingCalendar) {
            this.testingCalendar = testingCalendar;
            return this;
        }

        public BusinessCalendarImpl build() {
            return this.calendarBean == null ? new BusinessCalendarImpl(this.testingCalendar) : new BusinessCalendarImpl(this.calendarBean, this.testingCalendar);
        }
    }

    static class TimePeriod {
        private Date from;
        private Date to;

        protected TimePeriod(Date from, Date to) {
            this.from = from;
            this.to = to;
        }

        protected Date getFrom() {
            return this.from;
        }

        protected Date getTo() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TimePeriod)) {
                return false;
            }
            TimePeriod that = (TimePeriod)o;
            return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }

        public String toString() {
            return "TimePeriod{from=" + this.from + ", to=" + this.to + "}";
        }
    }
}

