/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.actions;

import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.util.VariableUtil;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItemManager;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalProcessInstanceAction
implements Action,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SignalProcessInstanceAction.class);
    public static final String DEFAULT_SCOPE = "default";
    public static final String PROCESS_INSTANCE_SCOPE = "processInstance";
    public static final String EXTERNAL_SCOPE = "external";
    public static final String UNSET_SCOPE = System.getProperty("org.jbpm.signals.defaultscope", "processInstance");
    private static final long serialVersionUID = 1L;
    private final String signalNameTemplate;
    private String variableNameExpression;
    private Function<KogitoProcessContext, Object> eventDataSupplier = kcontext -> null;
    private String scope = UNSET_SCOPE;
    private String inputVariable;

    public SignalProcessInstanceAction(String signalName, String variableNameExpression) {
        this.signalNameTemplate = signalName;
        this.variableNameExpression = variableNameExpression;
    }

    public SignalProcessInstanceAction(String signalName, String variableNameExpression, String scope) {
        this(signalName, variableNameExpression, null, scope);
    }

    public SignalProcessInstanceAction(String signalName, String variableNameExpression, String inputVariable, String scope) {
        this.signalNameTemplate = signalName;
        this.variableNameExpression = variableNameExpression;
        this.inputVariable = inputVariable;
        if (scope != null) {
            this.scope = scope;
        }
    }

    public SignalProcessInstanceAction(String signalName, Function<KogitoProcessContext, Object> eventDataSupplier, String scope) {
        this.signalNameTemplate = signalName;
        this.eventDataSupplier = eventDataSupplier;
        if (scope != null) {
            this.scope = scope;
        }
    }

    @Override
    public void execute(KogitoProcessContext context) throws Exception {
        String variableName = VariableUtil.resolveVariable(this.variableNameExpression, (NodeInstance)context.getNodeInstance());
        KogitoProcessInstance processInstance = context.getProcessInstance();
        KogitoNodeInstance nodeInstance = context.getNodeInstance();
        Object signal = null;
        if (this.inputVariable != null) {
            signal = context.getContextData().get(this.inputVariable);
        }
        if (signal == null) {
            signal = variableName != null ? context.getVariable(variableName) : this.eventDataSupplier.apply(context);
        }
        if (signal == null) {
            signal = variableName;
        }
        HashMap<String, Object> inputSet = new HashMap<String, Object>();
        inputSet.put("Data", signal);
        String signalName = VariableUtil.resolveVariable(this.signalNameTemplate, (NodeInstance)context.getNodeInstance());
        context.getKogitoProcessRuntime().getProcessEventSupport().fireOnSignal(processInstance, nodeInstance, context.getKieRuntime(), signalName, signal);
        LOG.debug("about to signal {} process {} with scope {}", new Object[]{signalName, processInstance.getId(), this.scope});
        if (DEFAULT_SCOPE.equals(this.scope)) {
            context.getKogitoProcessRuntime().signalEvent(signalName, signal);
        } else if (PROCESS_INSTANCE_SCOPE.equals(this.scope)) {
            context.getProcessInstance().signalEvent(signalName, signal);
        } else if (EXTERNAL_SCOPE.equals(this.scope)) {
            KogitoWorkItemImpl workItem = new KogitoWorkItemImpl();
            workItem.setId(UUID.randomUUID().toString());
            workItem.setName("External Send Task");
            workItem.setNodeInstanceId(context.getNodeInstance().getStringId());
            workItem.setProcessInstanceId(context.getProcessInstance().getStringId());
            workItem.setProcessInstance(processInstance);
            workItem.setNodeId(context.getNodeInstance().getNodeId());
            workItem.getParameters().putAll(inputSet);
            workItem.setParameter("Signal", (Object)signalName);
            workItem.setParameter("SignalProcessInstanceId", context.getVariable("SignalProcessInstanceId"));
            workItem.setParameter("SignalWorkItemId", context.getVariable("SignalWorkItemId"));
            workItem.setParameter("SignalDeploymentId", context.getVariable("SignalDeploymentId"));
            ((InternalKogitoWorkItemManager)context.getKogitoProcessRuntime().getKogitoWorkItemManager()).internalExecuteWorkItem((InternalKogitoWorkItem)workItem);
        }
    }

    public String getSignalName() {
        return this.signalNameTemplate;
    }
}

