/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.exception.CompensationHandler;
import org.jbpm.process.core.context.exception.CompensationScope;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.event.NonAcceptingEventTypeFilter;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.AbstractEventNodeFactory;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.WorkflowElementIdentifier;

public class BoundaryEventNodeFactory<T extends RuleFlowNodeContainerFactory<T, ?>>
extends AbstractEventNodeFactory<BoundaryEventNodeFactory<T>, T> {
    public static final String METHOD_ATTACHED_TO = "attachedTo";
    public static final String METHOD_ADD_COMPENSATION_HANDLER = "addCompensationHandler";
    private String attachedToUniqueId;

    public BoundaryEventNodeFactory(T nodeContainerFactory, NodeContainer nodeContainer, WorkflowElementIdentifier id) {
        super(nodeContainerFactory, nodeContainer, new BoundaryEventNode(), id);
    }

    protected BoundaryEventNode getBoundaryEventNode() {
        return (BoundaryEventNode)this.getNode();
    }

    public BoundaryEventNodeFactory<T> attachedTo(WorkflowElementIdentifier attachedToId) {
        return this.attachedTo(this.nodeContainer.getNode(attachedToId).getUniqueId());
    }

    public BoundaryEventNodeFactory<T> attachedTo(String attachedToId) {
        this.attachedToUniqueId = attachedToId;
        this.getBoundaryEventNode().setAttachedToNodeId(this.attachedToUniqueId);
        this.getBoundaryEventNode().setMetaData("AttachedTo", this.attachedToUniqueId);
        return this;
    }

    public BoundaryEventNodeFactory<T> addCompensationHandler(String compensationHandlerId) {
        if (!(this.nodeContainer instanceof ContextContainer)) {
            return this;
        }
        ContextContainer contextContainer = (ContextContainer)((Object)this.nodeContainer);
        Context compensationScope = contextContainer.getDefaultContext("CompensationScope");
        if (compensationScope instanceof CompensationScope) {
            CompensationHandler handler = new CompensationHandler();
            handler.setNode((Node)this.getBoundaryEventNode());
            ((CompensationScope)compensationScope).setExceptionHandler(compensationHandlerId, handler);
        }
        return this;
    }

    @Override
    public BoundaryEventNodeFactory<T> eventType(String eventType) {
        if ("Compensation".equalsIgnoreCase(eventType)) {
            NonAcceptingEventTypeFilter eventFilter = new NonAcceptingEventTypeFilter();
            eventFilter.setType(eventType);
            this.eventFilter(eventFilter);
        } else {
            super.eventType(eventType);
        }
        return this;
    }

    public BoundaryEventNodeFactory<T> eventType(String eventTypePrefix, String eventTypeSuffix) {
        if (this.attachedToUniqueId == null) {
            throw new IllegalStateException("attachedTo() must be called before");
        }
        EventTypeFilter filter = new EventTypeFilter();
        filter.setType(eventTypePrefix + "-" + this.attachedToUniqueId + "-" + eventTypeSuffix);
        super.eventFilter(filter);
        return this;
    }
}

