/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.impl;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.List;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.jbpm.process.instance.impl.AssignmentAction;
import org.jbpm.process.instance.impl.AssignmentProducer;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.jbpm.workflow.core.node.Assignment;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XPATHAssignmentAction
implements AssignmentAction {
    private Assignment assignment;
    private List<DataDefinition> sourcesDefinitions;
    private DataDefinition targetDefinition;

    public XPATHAssignmentAction(Assignment assignment, List<DataDefinition> sources, DataDefinition target) {
        this.assignment = assignment;
        this.sourcesDefinitions = sources;
        this.targetDefinition = target;
    }

    @Override
    public void execute(Function<String, Object> sourceResolver, Function<String, Object> targetResolver, AssignmentProducer producer) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        String from = this.assignment.getFrom().getExpression();
        XPath xpathFrom = factory.newXPath();
        XPathExpression exprFrom = null;
        XPath xpathTo = factory.newXPath();
        String to = this.assignment.getTo().getExpression();
        XPathExpression exprTo = xpathTo.compile(to);
        Object target = null;
        Object source = null;
        if (!this.sourcesDefinitions.isEmpty()) {
            source = sourceResolver.apply(this.sourcesDefinitions.get(0).getLabel());
            exprFrom = xpathFrom.compile(from);
        } else {
            source = this.assignment.getFrom().getExpression();
            exprFrom = xpathFrom.compile(".");
        }
        target = targetResolver.apply(this.targetDefinition.getLabel());
        Node sourceDOM = null;
        if (source instanceof Node) {
            sourceDOM = (Node)exprFrom.evaluate(source, XPathConstants.NODE);
        } else if (source instanceof String) {
            String sourceString = (String)source;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            sourceDOM = builder.parse(new InputSource(new ByteArrayInputStream(sourceString.getBytes()))).getFirstChild();
        }
        if (sourceDOM == null) {
            throw new RuntimeException("Nothing was selected by the from expression " + from + " on " + source);
        }
        if (target instanceof Node) {
            Node parentNode = (Node)target;
            Node parent = parentNode.getParentNode();
            Node targetElem = (Node)exprTo.evaluate(parent, XPathConstants.NODE);
            if (targetElem == null) {
                throw new RuntimeException("Nothing was selected by the to expression " + to + " on " + target);
            }
            Node n = targetElem.getOwnerDocument().importNode(sourceDOM, true);
            if (n instanceof Attr) {
                Attr attr = (Attr)n;
                ((Element)targetElem).setAttributeNode(attr);
            } else {
                targetElem.appendChild(n);
            }
            target = targetElem;
        } else if (Node.class.getName().equals(this.targetDefinition.getType())) {
            target = sourceDOM;
        } else if (sourceDOM instanceof Attr) {
            target = ((Attr)sourceDOM).getValue();
        } else if (sourceDOM instanceof Text) {
            target = ((Text)sourceDOM).getWholeText();
        } else {
            StringWriter writer = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(sourceDOM), new StreamResult(writer));
            target = writer.toString();
        }
        producer.accept(this.targetDefinition.getLabel(), target);
    }
}

