/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jbpm.ruleflow.core.WorkflowElementIdentifierFactory;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.NodeContainerImpl;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.EventNodeInterface;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.WorkflowElementIdentifier;

public class CompositeNode
extends StateBasedNode
implements NodeContainer,
EventNodeInterface {
    private static final long serialVersionUID = 510L;
    private NodeContainer nodeContainer;
    private Map<String, NodeAndType> inConnectionMap = new HashMap<String, NodeAndType>();
    private Map<String, NodeAndType> outConnectionMap = new HashMap<String, NodeAndType>();
    private boolean cancelRemainingInstances = true;
    private boolean autoComplete = true;

    public CompositeNode() {
        this.nodeContainer = new NodeContainerImpl();
    }

    public org.kie.api.definition.process.Node getNode(WorkflowElementIdentifier id) {
        return this.nodeContainer.getNode(id);
    }

    public org.kie.api.definition.process.Node getNodeByUniqueId(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeContainer getNodeContainer() {
        return this.nodeContainer;
    }

    @Override
    public org.kie.api.definition.process.Node internalGetNode(WorkflowElementIdentifier id) {
        return this.getNode(id);
    }

    public org.kie.api.definition.process.Node[] getNodes() {
        ArrayList<org.kie.api.definition.process.Node> subNodes = new ArrayList<org.kie.api.definition.process.Node>();
        for (org.kie.api.definition.process.Node node : this.nodeContainer.getNodes()) {
            if (node instanceof CompositeNodeStart || node instanceof CompositeNodeEnd) continue;
            subNodes.add(node);
        }
        return subNodes.toArray(new org.kie.api.definition.process.Node[subNodes.size()]);
    }

    public org.kie.api.definition.process.Node[] internalGetNodes() {
        return this.getNodes();
    }

    @Override
    public void addNode(org.kie.api.definition.process.Node node) {
        this.nodeContainer.addNode(node);
        ((Node)node).setParentContainer(this);
    }

    protected void internalAddNode(org.kie.api.definition.process.Node node) {
        this.addNode(node);
    }

    @Override
    public void removeNode(org.kie.api.definition.process.Node node) {
        this.nodeContainer.removeNode(node);
        ((Node)node).setParentContainer(null);
    }

    protected void internalRemoveNode(org.kie.api.definition.process.Node node) {
        this.removeNode(node);
    }

    @Override
    public boolean acceptsEvent(String type, Object event, Function<String, Object> varResolver) {
        for (org.kie.api.definition.process.Node node : this.internalGetNodes()) {
            if (!(node instanceof EventNodeInterface) || !((EventNodeInterface)node).acceptsEvent(type, event, varResolver)) continue;
            return true;
        }
        return false;
    }

    public void linkIncomingConnections(String inType, WorkflowElementIdentifier inNodeId, String inNodeType) {
        this.linkIncomingConnections(inType, new NodeAndType(this.nodeContainer, inNodeId, inNodeType));
    }

    public void linkIncomingConnections(String inType, NodeAndType inNode) {
        NodeAndType oldNodeAndType = this.inConnectionMap.get(inType);
        if (oldNodeAndType != null) {
            if (oldNodeAndType.equals(inNode)) {
                return;
            }
            List oldInConnections = oldNodeAndType.getNode().getIncomingConnections(oldNodeAndType.getType());
            if (oldInConnections != null) {
                for (Connection connection : new ArrayList(oldInConnections)) {
                    if (!(connection.getFrom() instanceof CompositeNodeStart)) continue;
                    this.removeNode(connection.getFrom());
                    ((ConnectionImpl)connection).terminate();
                }
            }
        }
        this.inConnectionMap.put(inType, inNode);
        if (inNode != null) {
            List<Connection> connections = this.getIncomingConnections(inType);
            for (Connection connection : connections) {
                CompositeNodeStart start = new CompositeNodeStart(this, connection.getFrom(), inType);
                this.internalAddNode((org.kie.api.definition.process.Node)start);
                if (inNode.getNode() == null) continue;
                new ConnectionImpl((org.kie.api.definition.process.Node)start, "DROOLS_DEFAULT", inNode.getNode(), inNode.getType());
            }
        }
    }

    public void linkOutgoingConnections(WorkflowElementIdentifier outNodeId, String outNodeType, String outType) {
        this.linkOutgoingConnections(new NodeAndType(this, outNodeId, outNodeType), outType);
    }

    public void linkOutgoingConnections(NodeAndType outNode, String outType) {
        NodeAndType oldNodeAndType = this.outConnectionMap.get(outType);
        if (oldNodeAndType != null) {
            if (oldNodeAndType.equals(outNode)) {
                return;
            }
            List oldOutConnections = oldNodeAndType.getNode().getOutgoingConnections(oldNodeAndType.getType());
            for (Connection connection : new ArrayList(oldOutConnections)) {
                if (!(connection.getTo() instanceof CompositeNodeEnd)) continue;
                this.removeNode(connection.getTo());
                ((ConnectionImpl)connection).terminate();
            }
        }
        this.outConnectionMap.put(outType, outNode);
        if (outNode != null) {
            List<Connection> connections = this.getOutgoingConnections(outType);
            for (Connection connection : connections) {
                CompositeNodeEnd end = new CompositeNodeEnd(this, connection.getTo(), outType);
                this.internalAddNode((org.kie.api.definition.process.Node)end);
                if (outNode.getNode() == null) continue;
                new ConnectionImpl(outNode.getNode(), outNode.getType(), (org.kie.api.definition.process.Node)end, "DROOLS_DEFAULT");
            }
        }
    }

    public NodeAndType getLinkedIncomingNode(String inType) {
        return this.inConnectionMap.get(inType);
    }

    public NodeAndType internalGetLinkedIncomingNode(String inType) {
        return this.inConnectionMap.get(inType);
    }

    public NodeAndType getLinkedOutgoingNode(String outType) {
        return this.outConnectionMap.get(outType);
    }

    public NodeAndType internalGetLinkedOutgoingNode(String outType) {
        return this.outConnectionMap.get(outType);
    }

    public Map<String, NodeAndType> getLinkedIncomingNodes() {
        return this.inConnectionMap;
    }

    public Map<String, NodeAndType> getLinkedOutgoingNodes() {
        return this.outConnectionMap;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        NodeImpl node;
        NodeAndType nodeAndType = this.internalGetLinkedIncomingNode(type);
        if (((Node)connection.getFrom()).getParentContainer() == this) {
            if (nodeAndType != null) {
                throw new IllegalArgumentException("Cannot link incoming connection type more than once: " + type);
            }
        } else if (nodeAndType != null && (node = (NodeImpl)nodeAndType.getNode()) != null) {
            node.validateAddIncomingConnection(nodeAndType.getType(), connection);
        }
    }

    @Override
    public void addIncomingConnection(String type, Connection connection) {
        if (((Node)connection.getFrom()).getParentContainer() == this) {
            this.linkOutgoingConnections(connection.getFrom().getId(), connection.getFromType(), "DROOLS_DEFAULT");
        } else {
            super.addIncomingConnection(type, connection);
            NodeAndType inNode = this.internalGetLinkedIncomingNode(type);
            if (inNode != null) {
                CompositeNodeStart start = new CompositeNodeStart(this, connection.getFrom(), type);
                this.internalAddNode((org.kie.api.definition.process.Node)start);
                NodeImpl node = (NodeImpl)inNode.getNode();
                if (node != null) {
                    new ConnectionImpl((org.kie.api.definition.process.Node)start, "DROOLS_DEFAULT", inNode.getNode(), inNode.getType());
                }
            }
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        NodeImpl node;
        NodeAndType nodeAndType = this.internalGetLinkedOutgoingNode(type);
        if (((Node)connection.getTo()).getParentContainer() == this) {
            if (nodeAndType != null) {
                throw new IllegalArgumentException("Cannot link outgoing connection type more than once: " + type);
            }
        } else if (nodeAndType != null && (node = (NodeImpl)nodeAndType.getNode()) != null) {
            ((NodeImpl)nodeAndType.getNode()).validateAddOutgoingConnection(nodeAndType.getType(), connection);
        }
    }

    @Override
    public void addOutgoingConnection(String type, Connection connection) {
        if (((Node)connection.getTo()).getParentContainer() == this) {
            this.linkIncomingConnections("DROOLS_DEFAULT", connection.getTo().getId(), connection.getToType());
        } else {
            super.addOutgoingConnection(type, connection);
            NodeAndType outNode = this.internalGetLinkedOutgoingNode(type);
            if (outNode != null) {
                CompositeNodeEnd end = new CompositeNodeEnd(this, connection.getTo(), type);
                this.internalAddNode((org.kie.api.definition.process.Node)end);
                NodeImpl node = (NodeImpl)outNode.getNode();
                if (node != null) {
                    new ConnectionImpl(outNode.getNode(), outNode.getType(), (org.kie.api.definition.process.Node)end, "DROOLS_DEFAULT");
                }
            }
        }
    }

    @Override
    public void validateRemoveIncomingConnection(String type, Connection connection) {
        NodeAndType nodeAndType = this.internalGetLinkedIncomingNode(type);
        if (nodeAndType != null) {
            for (Connection inConnection : nodeAndType.getNode().getIncomingConnections(nodeAndType.getType())) {
                if (((CompositeNodeStart)inConnection.getFrom()).getInNodeId() != connection.getFrom().getId()) continue;
                ((NodeImpl)nodeAndType.getNode()).validateRemoveIncomingConnection(nodeAndType.getType(), inConnection);
                return;
            }
            throw new IllegalArgumentException("Could not find internal incoming connection for node");
        }
    }

    @Override
    public void removeIncomingConnection(String type, Connection connection) {
        super.removeIncomingConnection(type, connection);
        NodeAndType nodeAndType = this.internalGetLinkedIncomingNode(type);
        if (nodeAndType != null) {
            for (Connection inConnection : nodeAndType.getNode().getIncomingConnections(nodeAndType.getType())) {
                if (((CompositeNodeStart)inConnection.getFrom()).getInNodeId() != connection.getFrom().getId()) continue;
                org.kie.api.definition.process.Node compositeNodeStart = inConnection.getFrom();
                ((ConnectionImpl)inConnection).terminate();
                this.internalRemoveNode(compositeNodeStart);
                return;
            }
            throw new IllegalArgumentException("Could not find internal incoming connection for node");
        }
    }

    @Override
    public void validateRemoveOutgoingConnection(String type, Connection connection) {
        NodeAndType nodeAndType = this.internalGetLinkedOutgoingNode(type);
        if (nodeAndType != null) {
            for (Connection outConnection : nodeAndType.getNode().getOutgoingConnections(nodeAndType.getType())) {
                if (((CompositeNodeEnd)outConnection.getTo()).getOutNodeId() != connection.getTo().getId()) continue;
                ((NodeImpl)nodeAndType.getNode()).validateRemoveOutgoingConnection(nodeAndType.getType(), outConnection);
                return;
            }
            throw new IllegalArgumentException("Could not find internal outgoing connection for node");
        }
    }

    @Override
    public void removeOutgoingConnection(String type, Connection connection) {
        super.removeOutgoingConnection(type, connection);
        NodeAndType nodeAndType = this.internalGetLinkedOutgoingNode(type);
        if (nodeAndType != null) {
            for (Connection outConnection : nodeAndType.getNode().getOutgoingConnections(nodeAndType.getType())) {
                if (((CompositeNodeEnd)outConnection.getTo()).getOutNodeId() != connection.getTo().getId()) continue;
                org.kie.api.definition.process.Node compositeNodeEnd = outConnection.getTo();
                ((ConnectionImpl)outConnection).terminate();
                this.internalRemoveNode(compositeNodeEnd);
                return;
            }
            throw new IllegalArgumentException("Could not find internal outgoing connection for node");
        }
    }

    public boolean isCancelRemainingInstances() {
        return this.cancelRemainingInstances;
    }

    public void setCancelRemainingInstances(boolean cancelRemainingInstances) {
        this.cancelRemainingInstances = cancelRemainingInstances;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public void setAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
    }

    @Override
    public String getVariableName() {
        return null;
    }

    public static class CompositeNodeStart
    extends NodeImpl {
        private static final long serialVersionUID = 510L;
        private CompositeNode parentNode;
        private WorkflowElementIdentifier inNodeId;
        private transient org.kie.api.definition.process.Node inNode;
        private String inType;

        public CompositeNodeStart(CompositeNode parentNode, org.kie.api.definition.process.Node outNode, String outType) {
            this.setId(WorkflowElementIdentifierFactory.fromExternalFormat(parentNode.getId().toExternalFormat() + ":composite:start"));
            this.setName("Composite node start");
            this.inNodeId = outNode.getId();
            this.inNode = outNode;
            this.inType = outType;
            this.parentNode = parentNode;
            this.setMetaData("hidden", true);
        }

        public org.kie.api.definition.process.Node getInNode() {
            if (this.inNode == null) {
                this.inNode = ((NodeContainer)this.parentNode.getParentContainer()).internalGetNode(this.inNodeId);
            }
            return this.inNode;
        }

        public WorkflowElementIdentifier getInNodeId() {
            return this.inNodeId;
        }

        public String getInType() {
            return this.inType;
        }
    }

    public static class CompositeNodeEnd
    extends NodeImpl {
        private static final long serialVersionUID = 510L;
        private CompositeNode parentNode;
        private WorkflowElementIdentifier outNodeId;
        private transient org.kie.api.definition.process.Node outNode;
        private String outType;

        public CompositeNodeEnd(CompositeNode parentNode, org.kie.api.definition.process.Node outNode, String outType) {
            this.setId(WorkflowElementIdentifierFactory.fromExternalFormat(parentNode.getId().toExternalFormat() + ":composite:end"));
            this.setName("Composite node end");
            this.outNodeId = outNode.getId();
            this.outNode = outNode;
            this.outType = outType;
            this.parentNode = parentNode;
            this.setMetaData("hidden", true);
        }

        public org.kie.api.definition.process.Node getOutNode() {
            if (this.outNode == null) {
                this.outNode = ((NodeContainer)this.parentNode.getParentContainer()).internalGetNode(this.outNodeId);
            }
            return this.outNode;
        }

        public WorkflowElementIdentifier getOutNodeId() {
            return this.outNodeId;
        }

        public String getOutType() {
            return this.outType;
        }
    }

    public static class NodeAndType
    implements Serializable {
        private static final long serialVersionUID = 510L;
        private NodeContainer nodeContainer;
        private WorkflowElementIdentifier nodeId;
        private String type;
        private transient org.kie.api.definition.process.Node node;

        public NodeAndType(NodeContainer nodeContainer, WorkflowElementIdentifier nodeId, String type) {
            if (type == null) {
                throw new IllegalArgumentException("Node or type may not be null!");
            }
            this.nodeId = nodeId;
            this.type = type;
            this.nodeContainer = nodeContainer;
        }

        public NodeAndType(org.kie.api.definition.process.Node node, String type) {
            if (node == null || type == null) {
                throw new IllegalArgumentException("Node or type may not be null!");
            }
            this.nodeId = node.getId();
            this.node = node;
            this.type = type;
        }

        public org.kie.api.definition.process.Node getNode() {
            if (this.node == null) {
                try {
                    this.node = this.nodeContainer.getNode(this.nodeId);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return this.node;
        }

        public WorkflowElementIdentifier getNodeId() {
            return this.nodeId;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o instanceof NodeAndType) {
                return this.nodeId == ((NodeAndType)o).nodeId && this.type.equals(((NodeAndType)o).type);
            }
            return false;
        }

        public int hashCode() {
            return 7 * this.nodeId.hashCode() + 13 * this.type.hashCode();
        }
    }
}

