/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalAgenda;
import org.jbpm.util.ContextFactory;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.EndNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.event.process.ContextAwareEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;

public class DynamicNodeInstance
extends CompositeContextNodeInstance {
    private static final long serialVersionUID = 510L;

    private String getRuleFlowGroupName() {
        return this.getNodeName();
    }

    protected DynamicNode getDynamicNode() {
        return (DynamicNode)this.getNode();
    }

    @Override
    public String getNodeName() {
        return this.resolveExpression(super.getNodeName());
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        this.triggerTime = new Date();
        this.triggerEvent("onEntry");
        if (this.getNodeInstanceContainer().getNodeInstance(this.getStringId()) == null) {
            return;
        }
        if (this.canActivate()) {
            this.triggerActivated();
        } else {
            this.setState(0);
            this.addActivationListener();
        }
    }

    private void triggerActivated() {
        this.setState(1);
        List<Node> autoStartNodes = this.getDynamicNode().getAutoStartNodes();
        autoStartNodes.forEach(autoStartNode -> this.triggerSelectedNode((Node)autoStartNode, null));
    }

    private boolean canActivate() {
        return this.getDynamicNode().canActivate(ContextFactory.fromNode(this));
    }

    private boolean canComplete() {
        return this.getNodeInstances(false).isEmpty() && this.getDynamicNode().canComplete(ContextFactory.fromNode(this));
    }

    private void addActivationListener() {
        this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime().addEventListener(ContextAwareEventListener.using(listener -> {
            if (this.canActivate() && this.getState() == 0) {
                this.triggerActivated();
                this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime().removeEventListener((ProcessEventListener)listener);
            }
        }));
    }

    private void addCompletionListener() {
        this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime().addEventListener(ContextAwareEventListener.using(listener -> {
            if (this.canComplete()) {
                this.triggerCompleted("DROOLS_DEFAULT");
            }
        }));
    }

    @Override
    public void nodeInstanceCompleted(NodeInstance nodeInstance, String outType) {
        Object compensationBoolObj;
        Node nodeInstanceNode = nodeInstance.getNode();
        if (nodeInstanceNode != null && Boolean.TRUE.equals(compensationBoolObj = nodeInstanceNode.getMetaData().get("isForCompensation"))) {
            return;
        }
        if (this.isTerminated(nodeInstance) || this.canComplete()) {
            this.triggerCompleted("DROOLS_DEFAULT");
        }
        if (!this.canComplete()) {
            this.addCompletionListener();
        }
    }

    @Override
    public void triggerCompleted(String outType) {
        if (this.getProcessInstance().getKnowledgeRuntime().getAgenda() != null) {
            ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).getAgendaGroupsManager().deactivateRuleFlowGroup(this.getRuleFlowGroupName());
        }
        super.triggerCompleted(outType);
    }

    protected boolean isTerminated(KogitoNodeInstance from) {
        if (from instanceof EndNodeInstance) {
            return ((EndNodeInstance)from).getEndNode().isTerminate();
        }
        return false;
    }

    protected void triggerSelectedNode(Node node, Object event) {
        NodeInstance nodeInstance = this.getNodeInstance(node);
        if (event != null) {
            HashMap<String, Object> dynamicParams = new HashMap<String, Object>();
            if (event instanceof Map) {
                dynamicParams.putAll((Map)event);
            } else {
                dynamicParams.put("Data", event);
            }
            nodeInstance.setDynamicParameters(dynamicParams);
        }
        nodeInstance.trigger(null, "DROOLS_DEFAULT");
    }
}

