/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.expr;

import java.util.Collection;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.kie.kogito.process.expr.Expression;
import org.kie.kogito.process.expr.ExpressionHandler;

public class ExpressionHandlerFactory {
    private static final Collection<ExpressionHandler> expressionHandlers = ServiceLoader.load(ExpressionHandler.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toUnmodifiableList());

    private ExpressionHandlerFactory() {
    }

    public static Expression get(String lang, String expr) {
        return ExpressionHandlerFactory.getExpressionHandler(lang).orElseThrow(() -> new IllegalArgumentException("Unsupported language " + lang)).get(expr);
    }

    public static boolean isSupported(String lang) {
        return expressionHandlers.stream().map(ExpressionHandler::lang).anyMatch(lang::equals);
    }

    private static Optional<ExpressionHandler> getExpressionHandler(String lang) {
        return expressionHandlers.stream().filter(p -> p.lang().equals(lang)).findFirst();
    }
}

