/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationProperty;
import org.kie.kogito.Model;
import org.kie.kogito.correlation.CompositeCorrelation;
import org.kie.kogito.correlation.Correlation;
import org.kie.kogito.correlation.CorrelationInstance;
import org.kie.kogito.internal.process.event.KogitoEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstanceContainer;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.internal.process.workitem.Policy;
import org.kie.kogito.internal.process.workitem.WorkItemNotFoundException;
import org.kie.kogito.internal.process.workitem.WorkItemTransition;
import org.kie.kogito.process.EventDescription;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.NodeInstanceNotFoundException;
import org.kie.kogito.process.NodeNotFoundException;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.Signal;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.flexible.AdHocFragment;
import org.kie.kogito.process.flexible.Milestone;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.process.impl.BaseWorkItem;
import org.kie.kogito.process.impl.lock.ProcessInstanceAtomicLockStrategy;
import org.kie.kogito.process.impl.lock.ProcessInstanceLockStrategy;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessInstance<T extends Model>
implements ProcessInstance<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProcessInstance.class);
    private static final String KOGITO_PROCESS_INSTANCE = "KogitoProcessInstance";
    protected final T variables;
    protected final AbstractProcess<T> process;
    protected InternalProcessRuntime rt;
    protected WorkflowProcessInstance processInstance;
    protected Integer status;
    private final AtomicBoolean removed;
    protected String id;
    protected CorrelationKey correlationKey;
    protected String description;
    protected ProcessError processError;
    protected Consumer<AbstractProcessInstance<?>> reloadSupplier;
    protected CompletionEventListener completionEventListener;
    protected long version;
    private Optional<CorrelationInstance> correlationInstance = Optional.empty();
    private ProcessInstanceLockStrategy processInstanceLockStrategy;

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, ProcessRuntime rt) {
        this(process, variables, null, rt);
    }

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, String businessKey, ProcessRuntime rt) {
        this(process, variables, businessKey, rt, null);
    }

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, String businessKey, ProcessRuntime rt, CompositeCorrelation correlation) {
        this.process = process;
        this.rt = (InternalProcessRuntime)rt;
        this.variables = variables;
        this.removed = new AtomicBoolean(false);
        this.processInstanceLockStrategy = ProcessInstanceAtomicLockStrategy.instance();
        this.setCorrelationKey(businessKey);
        Map<String, Object> map = this.bind(variables);
        org.kie.api.definition.process.Process processDefinition = process.get();
        if (processDefinition instanceof WorkflowProcess) {
            ((WorkflowProcess)processDefinition).getInputValidator().ifPresent(v -> v.validate(map));
        }
        String processId = processDefinition.getId();
        this.syncProcessInstance((WorkflowProcessInstance)((CorrelationAwareProcessRuntime)rt).createProcessInstance(processId, this.correlationKey, map));
        this.processInstance.setMetaData(KOGITO_PROCESS_INSTANCE, this);
        if (Objects.nonNull(correlation)) {
            this.correlationInstance = Optional.of(process.correlations().create((Correlation)correlation, this.id()));
        }
    }

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        this.process = process;
        this.variables = variables;
        this.syncProcessInstance((WorkflowProcessInstance)wpi);
        this.unbind(variables, this.processInstance.getVariables());
        this.removed = new AtomicBoolean(false);
        this.processInstanceLockStrategy = ProcessInstanceAtomicLockStrategy.instance();
    }

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, ProcessRuntime rt, org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        this.process = process;
        this.rt = (InternalProcessRuntime)rt;
        this.variables = variables;
        this.syncProcessInstance((WorkflowProcessInstance)wpi);
        this.reconnect();
        this.removed = new AtomicBoolean(false);
        this.processInstanceLockStrategy = ProcessInstanceAtomicLockStrategy.instance();
    }

    protected void reconnect() {
        LOG.debug("reconnect process {}", (Object)this.processInstance.getId());
        if (this.correlationInstance.isEmpty()) {
            this.correlationInstance = this.process().correlations().findByCorrelatedId(this.id());
        }
        if (this.processInstance.getKnowledgeRuntime() == null) {
            this.processInstance.setKnowledgeRuntime(this.getProcessRuntime().getInternalKieRuntime());
        }
        this.getProcessRuntime().getProcessInstanceManager().setLock(((MutableProcessInstances)this.process.instances()).lock());
        this.processInstance.reconnect();
        this.processInstance.setMetaData(KOGITO_PROCESS_INSTANCE, this);
        this.addCompletionEventListener();
        this.unbind(this.variables, this.processInstance.getVariables());
    }

    private void addCompletionEventListener() {
        if (this.completionEventListener == null) {
            this.completionEventListener = new CompletionEventListener();
            this.processInstance.addEventListener("processInstanceCompleted:" + this.id, this.completionEventListener, false);
        }
    }

    private void removeCompletionListener() {
        if (this.completionEventListener != null) {
            this.processInstance.removeEventListener("processInstanceCompleted:" + this.id, this.completionEventListener, false);
            this.completionEventListener = null;
        }
    }

    protected void disconnect() {
        if (this.processInstance == null) {
            return;
        }
        LOG.debug("disconnect process {}", (Object)this.processInstance.getId());
        this.processInstance.disconnect();
        this.processInstance.setMetaData(KOGITO_PROCESS_INSTANCE, null);
    }

    private void syncProcessInstance(WorkflowProcessInstance wpi) {
        this.internalSetProcessInstance(wpi);
        this.status = wpi.getState();
        this.id = wpi.getStringId();
        this.description = wpi.getDescription();
        this.setCorrelationKey(wpi.getCorrelationKey());
    }

    private void setCorrelationKey(String businessKey) {
        if (businessKey != null && !businessKey.trim().isEmpty()) {
            this.correlationKey = new StringCorrelationKey(businessKey);
        }
    }

    public Optional<Correlation<?>> correlation() {
        return this.correlationInstance.map(CorrelationInstance::getCorrelation);
    }

    public WorkflowProcessInstance internalGetProcessInstance() {
        return this.processInstance;
    }

    public void internalSetProcessInstance(WorkflowProcessInstance processInstance) {
        this.processInstance = processInstance;
        processInstance.wrap(this);
    }

    public void internalSetReloadSupplier(Consumer<AbstractProcessInstance<?>> reloadSupplier) {
        this.reloadSupplier = reloadSupplier;
    }

    public void internalRemoveProcessInstance() {
        if (this.processInstance == null) {
            return;
        }
        this.status = this.processInstance.getState();
        if (this.status == 5) {
            this.processError = this.buildProcessError();
        }
        this.removeCompletionListener();
        if (this.processInstance.getKnowledgeRuntime() != null) {
            this.disconnect();
        }
        this.processInstance = null;
    }

    public boolean hasHeader(String headerName) {
        return this.processInstance().getHeaders().containsKey(headerName);
    }

    public void start() {
        this.start(Collections.emptyMap());
    }

    public void start(Map<String, List<String>> headers) {
        this.start(null, null, headers);
    }

    public void start(String trigger, String referenceId) {
        this.start(trigger, referenceId, Collections.emptyMap());
    }

    public void start(String trigger, String referenceId, Map<String, List<String>> headers) {
        this.processInstanceLockStrategy.executeOperation(this.id, () -> {
            if (this.status != 0) {
                throw new IllegalStateException("Impossible to start process instance that already has started");
            }
            this.status = 1;
            if (referenceId != null) {
                this.processInstance.setReferenceId(referenceId);
            }
            if (headers != null) {
                this.processInstance.setHeaders(headers);
            }
            this.getProcessRuntime().getProcessInstanceManager().setLock(((MutableProcessInstances)this.process.instances()).lock());
            this.getProcessRuntime().getProcessInstanceManager().addProcessInstance(this.processInstance);
            this.id = this.processInstance.getStringId();
            this.addCompletionEventListener();
            ((MutableProcessInstances)this.process.instances()).create(this.id, (ProcessInstance)this);
            KogitoProcessInstance kogitoProcessInstance = this.getProcessRuntime().getKogitoProcessRuntime().startProcessInstance(this.id, trigger);
            if (kogitoProcessInstance.getState() != 3 && kogitoProcessInstance.getState() != 2) {
                ((MutableProcessInstances)this.process.instances()).update(this.id(), (ProcessInstance)this);
            }
            this.unbind(this.variables, kogitoProcessInstance.getVariables());
            if (this.processInstance != null) {
                this.status = this.processInstance.getState();
            }
            return null;
        });
    }

    public void abort() {
        this.processInstanceLockStrategy.executeOperation(this.id, () -> {
            String pid = this.processInstance().getStringId();
            this.getProcessRuntime().getKogitoProcessRuntime().abortProcessInstance(pid);
            this.removeOnFinish();
            return null;
        });
    }

    private InternalProcessRuntime getProcessRuntime() {
        if (this.rt == null) {
            throw new UnsupportedOperationException("Process instance is not connected to a Process Runtime");
        }
        return this.rt;
    }

    public <S> void send(Signal<S> signal) {
        this.processInstanceLockStrategy.executeOperation(this.id, () -> {
            if (signal.referenceId() != null) {
                this.processInstance().setReferenceId(signal.referenceId());
            }
            this.processInstance().signalEvent(signal.channel(), signal.payload());
            this.removeOnFinish();
            return null;
        });
    }

    public Process<T> process() {
        return this.process;
    }

    public T variables() {
        return this.variables;
    }

    public int status() {
        return this.status;
    }

    public String id() {
        return this.id;
    }

    public String businessKey() {
        return this.correlationKey == null ? null : this.correlationKey.getName();
    }

    public String description() {
        return this.description;
    }

    public Date startDate() {
        return this.processInstanceLockStrategy.executeOperation(this.id, () -> this.processInstance().getStartDate());
    }

    public long version() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public T updateVariables(T updates) {
        Map<String, Object> map = this.bind(updates);
        this.variables.update(map);
        return this.updateVariables(map);
    }

    public T updateVariablesPartially(T updates) {
        return this.updateVariables(this.variables.updatePartially(this.bind(updates)));
    }

    private T updateVariables(Map<String, Object> map) {
        return (T)this.processInstanceLockStrategy.executeOperation(this.id, () -> {
            for (Map.Entry entry : map.entrySet()) {
                this.processInstance().setVariable((String)entry.getKey(), entry.getValue());
            }
            ((MutableProcessInstances)this.process.instances()).update(this.id(), (ProcessInstance)this);
            return this.variables;
        });
    }

    public Optional<ProcessError> error() {
        return this.processInstanceLockStrategy.executeOperation(this.id, () -> {
            if (this.status == 5) {
                return Optional.of(this.processError != null ? this.processError : this.buildProcessError());
            }
            return Optional.empty();
        });
    }

    public void startFrom(String nodeId) {
        this.startFrom(nodeId, Collections.emptyMap());
    }

    public void startFrom(String nodeId, Map<String, List<String>> headers) {
        this.startFrom(nodeId, null, headers);
    }

    public void startFrom(String nodeId, String referenceId) {
        this.startFrom(nodeId, referenceId, Collections.emptyMap());
    }

    public void startFrom(String nodeId, String referenceId, Map<String, List<String>> headers) {
        this.processInstanceLockStrategy.executeOperation(this.id, () -> {
            this.processInstance.setStartDate(new Date());
            this.processInstance.setState(1);
            this.getProcessRuntime().getProcessInstanceManager().addProcessInstance(this.processInstance);
            this.id = this.processInstance.getStringId();
            this.addCompletionEventListener();
            if (referenceId != null) {
                this.processInstance.setReferenceId(referenceId);
            }
            if (headers != null) {
                this.processInstance.setHeaders(headers);
            }
            this.internalTriggerNode(nodeId);
            this.unbind(this.variables, this.processInstance.getVariables());
            if (this.processInstance() != null) {
                this.status = this.processInstance.getState();
            }
            ((MutableProcessInstances)this.process.instances()).create(this.id, (ProcessInstance)this);
            return null;
        });
    }

    public void triggerNode(String nodeId) {
        this.processInstanceLockStrategy.executeOperation(this.id, () -> {
            this.internalTriggerNode(nodeId);
            ((MutableProcessInstances)this.process.instances()).update(this.id, (ProcessInstance)this);
            return null;
        });
    }

    private void internalTriggerNode(String nodeId) {
        RuleFlowProcess rfp;
        WorkflowProcessInstance wfpi = this.processInstance();
        org.jbpm.workflow.instance.NodeInstance nodeInstance = wfpi.getNodeByPredicate(rfp = (RuleFlowProcess)wfpi.getProcess(), ni -> Objects.equals(nodeId, ni.getName()) || Objects.equals(nodeId, ni.getId().toExternalFormat()));
        if (nodeInstance == null) {
            throw new NodeNotFoundException(this.id, nodeId);
        }
        nodeInstance.trigger(null, "DROOLS_DEFAULT");
    }

    public void cancelNodeInstance(String nodeInstanceId) {
        this.processInstanceLockStrategy.executeOperation(this.id, () -> {
            org.jbpm.workflow.instance.NodeInstance nodeInstance = this.processInstance().getNodeInstances(true).stream().filter(ni -> ni.getStringId().equals(nodeInstanceId)).findFirst().orElseThrow(() -> new NodeInstanceNotFoundException(this.id, nodeInstanceId));
            nodeInstance.cancel();
            this.removeOnFinish();
            return null;
        });
    }

    public void retriggerNodeInstance(String nodeInstanceId) {
        this.processInstanceLockStrategy.executeOperation(this.id, () -> {
            org.jbpm.workflow.instance.NodeInstance nodeInstance = this.processInstance().getNodeInstances(true).stream().filter(ni -> ni.getStringId().equals(nodeInstanceId)).findFirst().orElseThrow(() -> new NodeInstanceNotFoundException(this.id, nodeInstanceId));
            ((NodeInstanceImpl)nodeInstance).retrigger(true);
            this.removeOnFinish();
            return null;
        });
    }

    protected WorkflowProcessInstance processInstance() {
        if (this.processInstance == null) {
            this.reloadSupplier.accept(this);
            if (this.processInstance == null) {
                throw new ProcessInstanceNotFoundException(this.id);
            }
            if (this.getProcessRuntime() != null) {
                this.reconnect();
            }
        }
        return this.processInstance;
    }

    public Collection<KogitoNodeInstance> findNodes(Predicate<KogitoNodeInstance> predicate) {
        return this.processInstanceLockStrategy.executeOperation(this.id, () -> this.processInstance().getKogitoNodeInstances(predicate, true));
    }

    public WorkItem workItem(String workItemId, Policy ... policies) {
        return this.processInstanceLockStrategy.executeOperation(this.id, () -> this.processInstance().getNodeInstances(true).stream().filter(WorkItemNodeInstance.class::isInstance).map(WorkItemNodeInstance.class::cast).filter(w -> this.enforceException((KogitoWorkItem)w.getWorkItem(), policies)).filter(ni -> ni.getWorkItemId().equals(workItemId)).map(this::toBaseWorkItem).findAny().orElseThrow(() -> new WorkItemNotFoundException("Work item with id " + workItemId + " was not found in process instance " + this.id(), workItemId)));
    }

    private boolean enforceException(KogitoWorkItem kogitoWorkItem, Policy ... policies) {
        Stream.of(policies).forEach(p -> p.enforce(kogitoWorkItem));
        return true;
    }

    public List<WorkItem> workItems(Policy ... policies) {
        return this.workItems(WorkItemNodeInstance.class::isInstance, policies);
    }

    public List<WorkItem> workItems(Predicate<KogitoNodeInstance> p, Policy ... policies) {
        return this.processInstanceLockStrategy.executeOperation(this.id, () -> this.processInstance().getNodeInstances(true).stream().filter(p::test).filter(WorkItemNodeInstance.class::isInstance).map(WorkItemNodeInstance.class::cast).filter(w -> this.enforce((KogitoWorkItem)w.getWorkItem(), policies)).map(this::toBaseWorkItem).toList());
    }

    private WorkItem toBaseWorkItem(WorkItemNodeInstance workItemNodeInstance) {
        InternalKogitoWorkItem workItem = workItemNodeInstance.getWorkItem();
        return new BaseWorkItem(workItemNodeInstance.getStringId(), workItemNodeInstance.getWorkItemId(), workItemNodeInstance.getNode().getId(), workItem.getParameters().getOrDefault("TaskName", workItemNodeInstance.getNodeName()), workItem.getName(), workItem.getState(), workItem.getPhaseId(), workItem.getPhaseStatus(), workItem.getParameters(), workItem.getResults(), workItem.getExternalReferenceId());
    }

    private boolean enforce(KogitoWorkItem kogitoWorkItem, Policy ... policies) {
        try {
            Stream.of(policies).forEach(p -> p.enforce(kogitoWorkItem));
            return true;
        }
        catch (Throwable th) {
            return false;
        }
    }

    public void completeWorkItem(String id, Map<String, Object> variables, Policy ... policies) {
        this.processInstanceLockStrategy.executeOperation(id, () -> {
            this.syncWorkItems();
            this.getProcessRuntime().getKogitoProcessRuntime().getKogitoWorkItemManager().completeWorkItem(id, variables, policies);
            this.removeOnFinish();
            return null;
        });
    }

    public <R> R updateWorkItem(String id, Function<KogitoWorkItem, R> updater, Policy ... policies) {
        return (R)this.processInstanceLockStrategy.executeOperation(id, () -> {
            this.syncWorkItems();
            Object result = this.getProcessRuntime().getKogitoProcessRuntime().getKogitoWorkItemManager().updateWorkItem(id, updater, policies);
            ((MutableProcessInstances)this.process.instances()).update(this.id(), (ProcessInstance)this);
            return result;
        });
    }

    public void abortWorkItem(String id, Policy ... policies) {
        this.processInstanceLockStrategy.executeOperation(id, () -> {
            this.syncWorkItems();
            this.getProcessRuntime().getKogitoProcessRuntime().getKogitoWorkItemManager().abortWorkItem(id, policies);
            this.removeOnFinish();
            return null;
        });
    }

    public void transitionWorkItem(String id, WorkItemTransition transition) {
        this.processInstanceLockStrategy.executeOperation(id, () -> {
            this.syncWorkItems();
            this.getProcessRuntime().getKogitoProcessRuntime().getKogitoWorkItemManager().transitionWorkItem(id, transition);
            this.removeOnFinish();
            return null;
        });
    }

    private void syncWorkItems() {
        for (NodeInstance nodeInstance : this.processInstance().getNodeInstances(true)) {
            if (!(nodeInstance instanceof WorkItemNodeInstance)) continue;
            WorkItemNodeInstance workItemNodeInstance = (WorkItemNodeInstance)nodeInstance;
            workItemNodeInstance.internalRegisterWorkItem();
        }
    }

    public Set<EventDescription<?>> events() {
        return this.processInstanceLockStrategy.executeOperation(this.id, () -> this.processInstance().getEventDescriptions());
    }

    public Collection<Milestone> milestones() {
        return this.processInstanceLockStrategy.executeOperation(this.id, () -> this.processInstance.milestones());
    }

    public Collection<AdHocFragment> adHocFragments() {
        return this.processInstanceLockStrategy.executeOperation(this.id, () -> this.processInstance.adHocFragments());
    }

    protected void removeOnFinish() {
        if (this.processInstance.getState() != 1 && this.processInstance.getState() != 5) {
            this.removeCompletionListener();
            this.syncProcessInstance(this.processInstance);
            this.remove();
        } else {
            ((MutableProcessInstances)this.process.instances()).update(this.id(), (ProcessInstance)this);
        }
        this.unbind(this.variables, this.processInstance().getVariables());
        this.status = this.processInstance.getState();
    }

    private void remove() {
        if (this.removed.getAndSet(true)) {
            return;
        }
        this.correlationInstance.map(CorrelationInstance::getCorrelation).ifPresent(c -> this.process.correlations().delete(c));
        ((MutableProcessInstances)this.process.instances()).remove(this.id());
    }

    protected Map<String, Object> bind(T variables) {
        HashMap<String, Object> vmap = new HashMap<String, Object>();
        if (variables == null) {
            return vmap;
        }
        try {
            for (Field f : variables.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                Object v = f.get(variables);
                vmap.put(f.getName(), v);
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        vmap.put("$v", variables);
        return vmap;
    }

    protected void unbind(T variables, Map<String, Object> vmap) {
        if (vmap == null) {
            return;
        }
        try {
            for (Field f : variables.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                f.set(variables, vmap.get(f.getName()));
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        vmap.put("$v", variables);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProcessInstance other = (AbstractProcessInstance)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }

    protected ProcessError buildProcessError() {
        WorkflowProcessInstance pi = this.processInstance();
        final String errorMessage = pi.getErrorMessage();
        final String nodeInError = pi.getNodeIdInError();
        final String nodeInstanceInError = pi.getNodeInstanceIdInError();
        final Throwable errorCause = pi.getErrorCause().orElse(null);
        return new ProcessError(){

            public String failedNodeId() {
                return nodeInError;
            }

            public String failedNodeInstanceId() {
                return nodeInstanceInError;
            }

            public String errorMessage() {
                return errorMessage;
            }

            public Throwable errorCause() {
                return errorCause;
            }

            public void retrigger() {
                WorkflowProcessInstanceImpl pInstance = (WorkflowProcessInstanceImpl)AbstractProcessInstance.this.processInstance();
                NodeInstanceImpl ni = (NodeInstanceImpl)pInstance.getByNodeDefinitionId(nodeInError, pInstance.getNodeContainer());
                this.clearError(pInstance);
                AbstractProcessInstance.this.getProcessRuntime().getProcessEventSupport().fireProcessRetriggered((KogitoProcessInstance)pInstance, (KieRuntime)pInstance.getKnowledgeRuntime());
                KogitoNodeInstanceContainer nodeInstanceContainer = ni.getNodeInstanceContainer();
                if (nodeInstanceContainer instanceof org.jbpm.workflow.instance.NodeInstance) {
                    ((org.jbpm.workflow.instance.NodeInstance)nodeInstanceContainer).internalSetTriggerTime(new Date());
                }
                ni.internalSetRetrigger(true);
                ni.trigger(null, "DROOLS_DEFAULT");
                AbstractProcessInstance.this.removeOnFinish();
            }

            public void skip() {
                WorkflowProcessInstanceImpl pInstance = (WorkflowProcessInstanceImpl)AbstractProcessInstance.this.processInstance();
                NodeInstanceImpl ni = (NodeInstanceImpl)pInstance.getByNodeDefinitionId(nodeInError, pInstance.getNodeContainer());
                this.clearError(pInstance);
                ni.triggerCompleted("DROOLS_DEFAULT", true);
                AbstractProcessInstance.this.removeOnFinish();
            }

            private void clearError(WorkflowProcessInstanceImpl pInstance) {
                pInstance.setState(1);
                pInstance.internalSetErrorNodeId(null);
                pInstance.internalSetErrorNodeInstanceId(null);
                pInstance.internalSetErrorMessage(null);
            }
        };
    }

    private class CompletionEventListener
    implements KogitoEventListener {
        private CompletionEventListener() {
        }

        public void signalEvent(String type, Object event) {
            ((WorkflowProcess)AbstractProcessInstance.this.process.get()).getOutputValidator().ifPresent(v -> v.validate(AbstractProcessInstance.this.processInstance.getVariables()));
            AbstractProcessInstance.this.removeOnFinish();
        }

        public String[] getEventTypes() {
            return new String[]{"processInstanceCompleted:" + AbstractProcessInstance.this.processInstance.getStringId()};
        }
    }

    private class StringCorrelationKey
    implements CorrelationKey {
        private final String correlationKey;

        public StringCorrelationKey(String correlationKey) {
            this.correlationKey = correlationKey;
        }

        public String getName() {
            return this.correlationKey;
        }

        public List<CorrelationProperty<?>> getProperties() {
            return Collections.emptyList();
        }

        public String toExternalForm() {
            return this.correlationKey;
        }
    }
}

