/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl.lock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.kie.kogito.process.impl.lock.ProcessInstanceLockStrategy;
import org.kie.kogito.process.impl.lock.WorkflowAtomicExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceAtomicLockStrategy
implements ProcessInstanceLockStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessInstanceAtomicLockStrategy.class);
    private static ProcessInstanceAtomicLockStrategy INSTANCE;
    private Map<String, ProcessInstanceLockHolder> locks = new ConcurrentHashMap<String, ProcessInstanceLockHolder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeOperation(String processInstanceId, WorkflowAtomicExecutor<T> executor) {
        ProcessInstanceLockHolder processInstanceLockHolder = this.locks.compute(processInstanceId, (pid, holder) -> {
            ProcessInstanceLockHolder newHolder = holder;
            if (newHolder == null) {
                newHolder = new ProcessInstanceLockHolder();
            }
            newHolder.addReference();
            LOG.trace("Creating lock {} from list as none is waiting for it by {}", (Object)newHolder.lock, pid);
            return newHolder;
        });
        boolean alreadyAcquired = processInstanceLockHolder.isHeldByCurrentThread();
        try {
            if (!alreadyAcquired) {
                LOG.trace("About to acquire lock for {}", (Object)processInstanceId);
            }
            processInstanceLockHolder.lock();
            if (!alreadyAcquired) {
                LOG.trace("Lock acquired for {}", (Object)processInstanceId);
            }
            T t = executor.execute();
            return t;
        }
        finally {
            processInstanceLockHolder.unlock();
            if (!alreadyAcquired) {
                LOG.trace("Lock released for {}", (Object)processInstanceId);
            }
            this.locks.computeIfPresent(processInstanceId, (pid, holder) -> {
                holder.removeReference();
                if (holder.isReferenced()) {
                    return holder;
                }
                LOG.trace("Removing lock {} from list as none is waiting for it by {}", (Object)holder.lock, pid);
                return null;
            });
        }
    }

    public static synchronized ProcessInstanceLockStrategy instance() {
        if (INSTANCE == null) {
            INSTANCE = new ProcessInstanceAtomicLockStrategy();
        }
        return INSTANCE;
    }

    private class ProcessInstanceLockHolder {
        Integer counter = 0;
        ReentrantLock lock = new ReentrantLock();

        void lock() {
            this.lock.lock();
        }

        void unlock() {
            this.lock.unlock();
        }

        boolean isReferenced() {
            return this.counter > 0;
        }

        boolean isHeldByCurrentThread() {
            return this.lock.isHeldByCurrentThread();
        }

        public void addReference() {
            Integer n = this.counter;
            this.counter = this.counter + 1;
        }

        public void removeReference() {
            Integer n = this.counter;
            this.counter = this.counter - 1;
        }
    }
}

