
package org.jbpm.serverless.workflow.api.functions;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "refName",
    "parameters"
})
public class FunctionRef implements Serializable
{

    /**
     * Name of the referenced function
     * (Required)
     * 
     */
    @JsonProperty("refName")
    @JsonPropertyDescription("Name of the referenced function")
    @Size(min = 1)
    @NotNull
    private java.lang.String refName;
    /**
     * Function parameters
     * 
     */
    @JsonProperty("parameters")
    @JsonPropertyDescription("Function parameters")
    @Valid
    private Map<String, String> parameters;
    private final static long serialVersionUID = -530786477949785865L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FunctionRef() {
    }

    /**
     * 
     * @param refName
     */
    public FunctionRef(java.lang.String refName) {
        super();
        this.refName = refName;
    }

    /**
     * Name of the referenced function
     * (Required)
     * 
     */
    @JsonProperty("refName")
    public java.lang.String getRefName() {
        return refName;
    }

    /**
     * Name of the referenced function
     * (Required)
     * 
     */
    @JsonProperty("refName")
    public void setRefName(java.lang.String refName) {
        this.refName = refName;
    }

    public FunctionRef withRefName(java.lang.String refName) {
        this.refName = refName;
        return this;
    }

    /**
     * Function parameters
     * 
     */
    @JsonProperty("parameters")
    public Map<String, String> getParameters() {
        return parameters;
    }

    /**
     * Function parameters
     * 
     */
    @JsonProperty("parameters")
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public FunctionRef withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

}
