
package org.jbpm.serverless.workflow.api.transitions;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.expression.Expression;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "expression",
    "nextState"
})
public class Transition implements Serializable
{

    @JsonProperty("expression")
    @Valid
    private Expression expression;
    /**
     * State to transition to next
     * (Required)
     * 
     */
    @JsonProperty("nextState")
    @JsonPropertyDescription("State to transition to next")
    @Size(min = 1)
    @NotNull
    private String nextState;
    private final static long serialVersionUID = -1883785741190455616L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Transition() {
    }

    /**
     * 
     * @param nextState
     */
    public Transition(String nextState) {
        super();
        this.nextState = nextState;
    }

    @JsonProperty("expression")
    public Expression getExpression() {
        return expression;
    }

    @JsonProperty("expression")
    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Transition withExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    /**
     * State to transition to next
     * (Required)
     * 
     */
    @JsonProperty("nextState")
    public String getNextState() {
        return nextState;
    }

    /**
     * State to transition to next
     * (Required)
     * 
     */
    @JsonProperty("nextState")
    public void setNextState(String nextState) {
        this.nextState = nextState;
    }

    public Transition withNextState(String nextState) {
        this.nextState = nextState;
        return this;
    }

}
